/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pluggable;

import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import buildcraft.api.transport.pluggable.IPipePluggableItem;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.ItemBuildCraft;
import buildcraft.core.utils.ColorUtils;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.pluggable.LensPluggable;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemLens
extends ItemBuildCraft
implements IPipePluggableItem {
    private IIcon[] icons;

    public ItemLens() {
        this.setHasSubtypes(true);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIconFromDamageForRenderPass(int meta, int pass) {
        return this.icons[meta >= 16 ? 1 + (pass & 1) : 1 - (pass & 1)];
    }

    @SideOnly(value=Side.CLIENT)
    public boolean requiresMultipleRenderPasses() {
        return true;
    }

    public int getDye(ItemStack stack) {
        return 15 - (stack.getItemDamage() & 0xF);
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemStack(ItemStack stack, int pass) {
        return pass == 0 ? ColorUtils.getRGBColor(this.getDye(stack)) : 0xFFFFFF;
    }

    public String getItemStackDisplayName(ItemStack itemstack) {
        return StringUtils.localize(itemstack.getItemDamage() >= 16 ? "item.Filter.name" : "item.Lens.name") + " (" + StringUtils.localize("color." + ColorUtils.getName(this.getDye(itemstack))) + ")";
    }

    @Override
    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister register) {
        this.icons = new IIcon[]{register.registerIcon("buildcraft:pipeLensItem0"), register.registerIcon("buildcraft:pipeLensItem1"), register.registerIcon("buildcraft:pipeFilterItem0")};
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(Item item, CreativeTabs tab, List itemList) {
        for (int i = 0; i < 32; ++i) {
            itemList.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public PipePluggable createPipePluggable(IPipe pipe, ForgeDirection side, ItemStack stack) {
        if (pipe.getTile().getPipeType() == IPipeTile.PipeType.ITEM) {
            return new LensPluggable(stack);
        }
        return null;
    }
}

