/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.recipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.core.JavaTools;
import buildcraft.api.facades.FacadeType;
import buildcraft.api.facades.IFacadeItem;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.api.transport.PipeWire;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemPipeWire;
import buildcraft.transport.recipes.IntegrationTableRecipe;
import net.minecraft.item.ItemStack;

public class AdvancedFacadeRecipe
extends IntegrationTableRecipe {
    public AdvancedFacadeRecipe(String id) {
        this.setContents(id, new ItemFacade(), 50000, 0L, new ItemStack(BuildCraftTransport.pipeWire, 1, Short.MAX_VALUE), ItemRedstoneChipset.Chipset.RED.getStack());
    }

    @Override
    public boolean isValidInputA(ItemStack inputA) {
        return inputA != null && inputA.getItem() instanceof ItemFacade;
    }

    @Override
    public boolean isValidInputB(ItemStack inputB) {
        return inputB != null && (inputB.getItem() instanceof ItemFacade && ((IFacadeItem)inputB.getItem()).getFacadeType(inputB) == FacadeType.Basic || inputB.getItem() == BuildCraftTransport.plugItem);
    }

    @Override
    public CraftingResult<ItemStack> craft(TileIntegrationTable crafter, boolean preview, ItemStack inputA, ItemStack inputB) {
        CraftingResult<ItemStack> result = super.craft(crafter, preview, inputA, inputB);
        if (result == null) {
            return null;
        }
        PipeWire wire = null;
        for (ItemStack stack : result.usedItems) {
            if (stack == null || !(stack.getItem() instanceof ItemPipeWire)) continue;
            wire = PipeWire.fromOrdinal(stack.getItemDamage());
            break;
        }
        if (wire != null) {
            ItemFacade.FacadeState additionalState;
            ItemFacade.FacadeState[] states = ItemFacade.getFacadeStates(inputA);
            if (inputB.getItem() == BuildCraftTransport.plugItem) {
                additionalState = ItemFacade.FacadeState.createTransparent(wire);
            } else {
                additionalState = ItemFacade.getFacadeStates(inputB)[0];
                additionalState = ItemFacade.FacadeState.create(additionalState.block, additionalState.metadata, wire);
            }
            for (int i = 0; i < states.length; ++i) {
                if (states[i].wire != wire) continue;
                states[i] = additionalState;
                result.energyCost = 20000;
                result.crafted = ItemFacade.getFacade(states);
                return result;
            }
            result.energyCost = 50000;
            result.crafted = ItemFacade.getFacade(JavaTools.concat(states, new ItemFacade.FacadeState[]{additionalState}));
            return result;
        }
        return null;
    }
}

