/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.recipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.core.inventory.StackHelper;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.recipes.IntegrationTableRecipe;
import net.minecraft.item.ItemStack;

public class GateExpansionRecipe
extends IntegrationTableRecipe {
    private final IGateExpansion expansion;
    private final ItemStack chipset;

    public GateExpansionRecipe(String id, IGateExpansion expansion, ItemStack chipset) {
        this.expansion = expansion;
        this.chipset = chipset.copy();
        this.setContents(id, BuildCraftTransport.pipeGate, 100000, 0L, new Object[0]);
    }

    @Override
    public boolean isValidInputA(ItemStack inputA) {
        if (inputA == null) {
            return false;
        }
        if (!(inputA.getItem() instanceof ItemGate)) {
            return false;
        }
        return !ItemGate.hasGateExpansion(inputA, this.expansion);
    }

    @Override
    public boolean isValidInputB(ItemStack inputB) {
        return StackHelper.isMatchingItem(inputB, this.chipset);
    }

    @Override
    public CraftingResult<ItemStack> craft(TileIntegrationTable crafter, boolean preview, ItemStack inputA, ItemStack inputB) {
        if (inputA == null) {
            return null;
        }
        CraftingResult<ItemStack> result = super.craft(crafter, preview, inputA, inputB);
        if (result == null) {
            return null;
        }
        ItemStack output = inputA;
        output.stackSize = 1;
        ItemGate.addGateExpansion(output, this.expansion);
        result.crafted = output;
        return result;
    }
}

