/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.recipes;

import buildcraft.BuildCraftTransport;
import buildcraft.api.recipes.CraftingResult;
import buildcraft.core.inventory.StackHelper;
import buildcraft.silicon.ItemRedstoneChipset;
import buildcraft.silicon.TileIntegrationTable;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.recipes.IntegrationTableRecipe;
import net.minecraft.item.ItemStack;

public class GateLogicSwapRecipe
extends IntegrationTableRecipe {
    public GateLogicSwapRecipe(String id) {
        this.setContents(id, BuildCraftTransport.pipeGate, 20000, 0L, new Object[0]);
    }

    @Override
    public boolean isValidInputA(ItemStack inputA) {
        return inputA != null && inputA.getItem() instanceof ItemGate && ItemGate.getMaterial(inputA) != GateDefinition.GateMaterial.REDSTONE;
    }

    @Override
    public boolean isValidInputB(ItemStack inputB) {
        return StackHelper.isMatchingItem(inputB, ItemRedstoneChipset.Chipset.RED.getStack());
    }

    @Override
    public CraftingResult<ItemStack> craft(TileIntegrationTable crafter, boolean preview, ItemStack inputA, ItemStack inputB) {
        CraftingResult<ItemStack> result = super.craft(crafter, preview, inputA, inputB);
        if (result == null) {
            return null;
        }
        ItemStack output = inputA;
        output.stackSize = 1;
        ItemGate.setLogic(output, ItemGate.getLogic(output) == GateDefinition.GateLogic.AND ? GateDefinition.GateLogic.OR : GateDefinition.GateLogic.AND);
        result.crafted = output;
        return result;
    }
}

