/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.api.core.IIconProvider;
import buildcraft.api.core.render.ITextureStates;
import buildcraft.api.transport.pluggable.IPipePluggableRenderer;
import buildcraft.api.transport.pluggable.PipePluggable;
import buildcraft.core.utils.ColorUtils;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.render.FacadeRenderHelper;
import buildcraft.transport.render.FakeBlock;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeRendererWorld
implements ISimpleBlockRenderingHandler {
    public static int renderPass = -1;
    public static float zFightOffset = 2.4414062E-4f;

    public void renderPipe(RenderBlocks renderblocks, IBlockAccess iblockaccess, TileGenericPipe tile, int x, int y, int z) {
        PipeRenderState state = tile.renderState;
        IIconProvider icons = tile.getPipeIcons();
        FakeBlock fakeBlock = FakeBlock.INSTANCE;
        int glassColor = tile.getPipeColor();
        if (icons == null) {
            return;
        }
        if (renderPass == 0 || glassColor >= 0) {
            int connectivity = state.pipeConnectionMatrix.getMask();
            float[] dim = new float[6];
            if (renderPass == 1) {
                fakeBlock.setColor(ColorUtils.getRGBColor(glassColor));
            }
            if (connectivity != 63) {
                this.resetToCenterDimensions(dim);
                if (renderPass == 0) {
                    fakeBlock.getTextureState().set(icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.UNKNOWN)));
                } else {
                    fakeBlock.getTextureState().set(PipeIconProvider.TYPE.PipeStainedOverlay.getIcon());
                }
                this.fixForRenderPass(dim);
                this.renderTwoWayBlock(renderblocks, fakeBlock, x, y, z, dim, connectivity ^ 0x3F);
            }
            for (int dir = 0; dir < 6; ++dir) {
                int mask = 1 << dir;
                if ((connectivity & mask) == 0) continue;
                this.resetToCenterDimensions(dim);
                dim[dir / 2] = dir % 2 == 0 ? 0.0f : 0.75f;
                dim[dir / 2 + 3] = dir % 2 == 0 ? 0.25f : 1.0f;
                int renderMask = 3 << dir / 2 * 2 ^ 0x3F;
                this.fixForRenderPass(dim);
                if (renderPass == 0) {
                    fakeBlock.getTextureState().set(icons.getIcon(state.textureMatrix.getTextureIndex(ForgeDirection.VALID_DIRECTIONS[dir])));
                } else {
                    fakeBlock.getTextureState().set(PipeIconProvider.TYPE.PipeStainedOverlay.getIcon());
                }
                this.renderTwoWayBlock(renderblocks, fakeBlock, x, y, z, dim, renderMask);
            }
            fakeBlock.setColor(0xFFFFFF);
        }
        renderblocks.setRenderBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        this.pipeFacadeRenderer(renderblocks, fakeBlock, tile, state, x, y, z);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            PipePluggable p;
            IPipePluggableRenderer r;
            if (!tile.hasPipePluggable(dir) || (r = (p = tile.getPipePluggable(dir)).getRenderer()) == null) continue;
            r.renderPluggable(renderblocks, tile.getPipe(), dir, p, fakeBlock, renderPass, x, y, z);
        }
    }

    private void fixForRenderPass(float[] dim) {
        if (renderPass == 1) {
            int i = 0;
            while (i < 3) {
                int n = i++;
                dim[n] = dim[n] + zFightOffset;
            }
            i = 3;
            while (i < 6) {
                int n = i++;
                dim[n] = dim[n] - zFightOffset;
            }
        }
    }

    private void resetToCenterDimensions(float[] dim) {
        int i;
        for (i = 0; i < 3; ++i) {
            dim[i] = 0.25f;
        }
        for (i = 3; i < 6; ++i) {
            dim[i] = 0.75f;
        }
    }

    private void renderTwoWayBlock(RenderBlocks renderblocks, FakeBlock stateHost, int x, int y, int z, float[] dim, int mask) {
        assert (mask != 0);
        stateHost.setRenderMask(mask);
        renderblocks.setRenderBounds((double)dim[2], (double)dim[0], (double)dim[1], (double)dim[5], (double)dim[3], (double)dim[4]);
        renderblocks.renderStandardBlock((Block)stateHost, x, y, z);
        stateHost.setRenderMask((mask & 0x15) << 1 | (mask & 0x2A) >> 1);
        renderblocks.setRenderBounds((double)dim[5], (double)dim[3], (double)dim[4], (double)dim[2], (double)dim[0], (double)dim[1]);
        renderblocks.renderStandardBlock((Block)stateHost, x, y, z);
    }

    private void pipeFacadeRenderer(RenderBlocks renderblocks, ITextureStates blockStateMachine, TileGenericPipe tile, PipeRenderState state, int x, int y, int z) {
        FacadeRenderHelper.pipeFacadeRenderer(renderblocks, blockStateMachine, tile, state, x, y, z);
    }

    public void renderInventoryBlock(Block block, int metadata, int modelID, RenderBlocks renderer) {
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        TileEntity tile = world.getTileEntity(x, y, z);
        Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
        Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
        Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
        Tessellator.instance.addVertexWithUV((double)x, (double)y, (double)z, 0.0, 0.0);
        if (tile instanceof TileGenericPipe) {
            TileGenericPipe pipeTile = (TileGenericPipe)tile;
            this.renderPipe(renderer, world, pipeTile, x, y, z);
        }
        return true;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return false;
    }

    public int getRenderId() {
        return TransportProxy.pipeModel;
    }
}

