/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Gate;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class ActionParameterSignal
implements IStatementParameter {
    private static IIcon[] icons;
    public PipeWire color = null;

    @Override
    public IIcon getIcon() {
        if (this.color == null) {
            return null;
        }
        return icons[this.color.ordinal()];
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        int maxColor = 4;
        if (source instanceof Gate) {
            maxColor = ((Gate)source).material.maxWireColor;
        }
        if (this.color == null) {
            this.color = mouse.getButton() == 0 ? PipeWire.RED : PipeWire.values()[maxColor - 1];
        } else if (this.color == (mouse.getButton() == 0 ? PipeWire.values()[maxColor - 1] : PipeWire.RED)) {
            this.color = null;
        } else {
            do {
                this.color = PipeWire.values()[(mouse.getButton() == 0 ? this.color.ordinal() + 1 : this.color.ordinal() - 1) & 3];
            } while (this.color.ordinal() >= maxColor);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        if (this.color != null) {
            nbt.setByte("color", (byte)this.color.ordinal());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.hasKey("color")) {
            this.color = PipeWire.values()[nbt.getByte("color")];
        }
    }

    public boolean equals(Object object) {
        if (object instanceof ActionParameterSignal) {
            ActionParameterSignal param = (ActionParameterSignal)object;
            return param.color == this.color;
        }
        return false;
    }

    @Override
    public String getDescription() {
        if (this.color == null) {
            return null;
        }
        return String.format(StringUtils.localize("gate.action.pipe.wire"), StringUtils.localize("color." + this.color.name().toLowerCase(Locale.ENGLISH)));
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:pipeWireAction";
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        icons = new IIcon[]{iconRegister.registerIcon("buildcraft:triggers/trigger_pipesignal_red_active"), iconRegister.registerIcon("buildcraft:triggers/trigger_pipesignal_blue_active"), iconRegister.registerIcon("buildcraft:triggers/trigger_pipesignal_green_active"), iconRegister.registerIcon("buildcraft:triggers/trigger_pipesignal_yellow_active")};
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }

    @Override
    public ItemStack getItemStack() {
        return null;
    }
}

