/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.statements;

import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.transport.IPipe;
import buildcraft.core.statements.BCStatement;
import buildcraft.core.statements.StatementParameterDirection;
import buildcraft.core.utils.StringUtils;
import buildcraft.transport.Gate;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraftforge.common.util.ForgeDirection;

public class ActionValve
extends BCStatement
implements IActionInternal {
    public final ValveState state;

    public ActionValve(ValveState valveState) {
        super("buildcraft:pipe.valve." + valveState.name().toLowerCase(Locale.ENGLISH));
        this.state = valveState;
    }

    @Override
    public String getDescription() {
        return StringUtils.localize("gate.action.pipe.valve." + this.state.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
        this.icon = iconRegister.registerIcon("buildcraft:triggers/action_valve_" + this.state.name().toLowerCase(Locale.ENGLISH));
    }

    @Override
    public int maxParameters() {
        return 1;
    }

    @Override
    public int minParameters() {
        return 0;
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return new StatementParameterDirection();
    }

    @Override
    public void actionActivate(IStatementContainer container, IStatementParameter[] parameters) {
        IPipe pipe = ((Gate)container).getPipe();
        if (pipe != null && pipe instanceof Pipe) {
            Object transport = ((Pipe)pipe).transport;
            if (parameters[0] != null && parameters[0] instanceof StatementParameterDirection) {
                ForgeDirection side = ((StatementParameterDirection)parameters[0]).direction;
                if (side != ForgeDirection.UNKNOWN) {
                    ((PipeTransport)transport).allowInput(side, this.state.inputOpen);
                    ((PipeTransport)transport).allowOutput(side, this.state.outputOpen);
                }
            } else {
                for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                    ((PipeTransport)transport).allowInput(side, this.state.inputOpen);
                    ((PipeTransport)transport).allowOutput(side, this.state.outputOpen);
                }
            }
        }
    }

    public static enum ValveState {
        OPEN(true, true),
        INPUT_ONLY(true, false),
        OUTPUT_ONLY(false, true),
        CLOSED(false, false);

        public static final ValveState[] VALUES;
        public final boolean inputOpen;
        public final boolean outputOpen;

        private ValveState(boolean in, boolean out) {
            this.inputOpen = in;
            this.outputOpen = out;
        }

        static {
            VALUES = ValveState.values();
        }
    }
}

