/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class StripesHandlerArrow
implements IStripesHandler {
    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return stack.getItem() == Items.arrow;
    }

    @Override
    public boolean handle(World world, int x, int y, int z, ForgeDirection direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        EntityArrow entityArrow = new EntityArrow(world, (EntityLivingBase)player, 0.0f);
        entityArrow.setPosition((double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        entityArrow.setDamage(3.0);
        entityArrow.setKnockbackStrength(1);
        entityArrow.motionX = (double)direction.offsetX * 1.8 + world.rand.nextGaussian() * (double)0.0075f;
        entityArrow.motionY = (double)direction.offsetY * 1.8 + world.rand.nextGaussian() * (double)0.0075f;
        entityArrow.motionZ = (double)direction.offsetZ * 1.8 + world.rand.nextGaussian() * (double)0.0075f;
        world.spawnEntityInWorld((Entity)entityArrow);
        --stack.stackSize;
        if (stack.stackSize > 0) {
            activator.sendItem(stack, direction.getOpposite());
        }
        return true;
    }
}

