/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.stripes;

import buildcraft.api.transport.IStripesActivator;
import buildcraft.api.transport.IStripesHandler;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class StripesHandlerEntityInteract
implements IStripesHandler {
    @Override
    public IStripesHandler.StripesHandlerType getType() {
        return IStripesHandler.StripesHandlerType.ITEM_USE;
    }

    @Override
    public boolean shouldHandle(ItemStack stack) {
        return true;
    }

    @Override
    public boolean handle(World world, int x, int y, int z, ForgeDirection direction, ItemStack stack, EntityPlayer player, IStripesActivator activator) {
        AxisAlignedBB box = AxisAlignedBB.getBoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        List entities = world.getEntitiesWithinAABBExcludingEntity(null, box);
        if (entities.size() <= 0) {
            return false;
        }
        LinkedList<EntityLivingBase> livingEntities = new LinkedList<EntityLivingBase>();
        for (Object entityObj : entities) {
            if (!(entityObj instanceof EntityLivingBase)) continue;
            livingEntities.add((EntityLivingBase)entityObj);
        }
        player.setCurrentItemOrArmor(0, stack);
        boolean successful = false;
        Collections.shuffle(livingEntities);
        while (livingEntities.size() > 0) {
            EntityLivingBase entity = (EntityLivingBase)livingEntities.remove(0);
            if (!player.interactWith((Entity)entity)) continue;
            successful = true;
            this.dropItemsExcept(stack, player, activator, direction);
        }
        if (stack.stackSize > 0 && successful) {
            activator.sendItem(stack, direction.getOpposite());
        }
        return successful;
    }

    private void dropItemsExcept(ItemStack stack, EntityPlayer player, IStripesActivator activator, ForgeDirection direction) {
        for (int i = 0; i < player.inventory.getSizeInventory(); ++i) {
            ItemStack invStack = player.inventory.getStackInSlot(i);
            if (invStack == null || invStack == stack) continue;
            player.inventory.setInventorySlotContents(i, null);
            activator.sendItem(invStack, direction.getOpposite());
        }
    }
}

