/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.core;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.ISerializable;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class Position
implements ISerializable {
    public double x;
    public double y;
    public double z;
    public ForgeDirection orientation;

    public Position() {
        this.x = 0.0;
        this.y = 0.0;
        this.z = 0.0;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public Position(double ci, double cj, double ck) {
        this.x = ci;
        this.y = cj;
        this.z = ck;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public Position(double ci, double cj, double ck, ForgeDirection corientation) {
        this.x = ci;
        this.y = cj;
        this.z = ck;
        this.orientation = corientation;
        if (this.orientation == null) {
            this.orientation = ForgeDirection.UNKNOWN;
        }
    }

    public Position(Position p) {
        this.x = p.x;
        this.y = p.y;
        this.z = p.z;
        this.orientation = p.orientation;
    }

    public Position(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    public Position(TileEntity tile) {
        this.x = tile.xCoord;
        this.y = tile.yCoord;
        this.z = tile.zCoord;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public Position(BlockIndex index) {
        this.x = index.x;
        this.y = index.y;
        this.z = index.z;
        this.orientation = ForgeDirection.UNKNOWN;
    }

    public void moveRight(double step) {
        switch (this.orientation) {
            case SOUTH: {
                this.x -= step;
                break;
            }
            case NORTH: {
                this.x += step;
                break;
            }
            case EAST: {
                this.z += step;
                break;
            }
            case WEST: {
                this.z -= step;
                break;
            }
        }
    }

    public void moveLeft(double step) {
        this.moveRight(-step);
    }

    public void moveForwards(double step) {
        switch (this.orientation) {
            case UP: {
                this.y += step;
                break;
            }
            case DOWN: {
                this.y -= step;
                break;
            }
            case SOUTH: {
                this.z += step;
                break;
            }
            case NORTH: {
                this.z -= step;
                break;
            }
            case EAST: {
                this.x += step;
                break;
            }
            case WEST: {
                this.x -= step;
                break;
            }
        }
    }

    public void moveBackwards(double step) {
        this.moveForwards(-step);
    }

    public void moveUp(double step) {
        switch (this.orientation) {
            case SOUTH: 
            case NORTH: 
            case EAST: 
            case WEST: {
                this.y += step;
                break;
            }
        }
    }

    public void moveDown(double step) {
        this.moveUp(-step);
    }

    public void writeToNBT(NBTTagCompound nbttagcompound) {
        if (this.orientation == null) {
            this.orientation = ForgeDirection.UNKNOWN;
        }
        nbttagcompound.setDouble("i", this.x);
        nbttagcompound.setDouble("j", this.y);
        nbttagcompound.setDouble("k", this.z);
        nbttagcompound.setByte("orientation", (byte)this.orientation.ordinal());
    }

    public void readFromNBT(NBTTagCompound nbttagcompound) {
        this.x = nbttagcompound.getDouble("i");
        this.y = nbttagcompound.getDouble("j");
        this.z = nbttagcompound.getDouble("k");
        this.orientation = ForgeDirection.values()[nbttagcompound.getByte("orientation")];
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + ", " + this.z + "}";
    }

    public Position min(Position p) {
        return new Position(p.x > this.x ? this.x : p.x, p.y > this.y ? this.y : p.y, p.z > this.z ? this.z : p.z);
    }

    public Position max(Position p) {
        return new Position(p.x < this.x ? this.x : p.x, p.y < this.y ? this.y : p.y, p.z < this.z ? this.z : p.z);
    }

    public boolean isClose(Position newPosition, float f) {
        double dx = this.x - newPosition.x;
        double dy = this.y - newPosition.y;
        double dz = this.z - newPosition.z;
        double sqrDis = dx * dx + dy * dy + dz * dz;
        return !(sqrDis > (double)(f * f));
    }

    @Override
    public void readData(ByteBuf stream) {
        this.x = stream.readDouble();
        this.y = stream.readDouble();
        this.z = stream.readDouble();
        this.orientation = ForgeDirection.getOrientation((int)stream.readByte());
    }

    @Override
    public void writeData(ByteBuf stream) {
        stream.writeDouble(this.x);
        stream.writeDouble(this.y);
        stream.writeDouble(this.z);
        stream.writeByte(this.orientation.ordinal());
    }

    public int hashCode() {
        return 51 * (int)this.x + 13 * (int)this.y + (int)this.z;
    }
}

