/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.statements;

import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementMouseClick;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class StatementParameterItemStack
implements IStatementParameter {
    protected ItemStack stack;

    @Override
    public IIcon getIcon() {
        return null;
    }

    @Override
    public ItemStack getItemStack() {
        return this.stack;
    }

    @Override
    public void onClick(IStatementContainer source, IStatement stmt, ItemStack stack, StatementMouseClick mouse) {
        if (stack != null) {
            this.stack = stack.copy();
            this.stack.stackSize = 1;
        } else {
            this.stack = null;
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        if (this.stack != null) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            this.stack.writeToNBT(tagCompound);
            compound.setTag("stack", (NBTBase)tagCompound);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        this.stack = ItemStack.loadItemStackFromNBT((NBTTagCompound)compound.getCompoundTag("stack"));
    }

    public boolean equals(Object object) {
        if (object instanceof StatementParameterItemStack) {
            StatementParameterItemStack param = (StatementParameterItemStack)object;
            return ItemStack.areItemStacksEqual((ItemStack)this.stack, (ItemStack)param.stack) && ItemStack.areItemStackTagsEqual((ItemStack)this.stack, (ItemStack)param.stack);
        }
        return false;
    }

    @Override
    public String getDescription() {
        if (this.stack != null) {
            return this.stack.getDisplayName();
        }
        return "";
    }

    @Override
    public String getUniqueTag() {
        return "buildcraft:stack";
    }

    @Override
    public void registerIcons(IIconRegister iconRegister) {
    }

    @Override
    public IStatementParameter rotateLeft() {
        return this;
    }
}

