/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Translation;
import buildcraft.api.core.IInvSlot;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Schematic {
    public boolean isItemMatchingRequirement(ItemStack suppliedStack, ItemStack requiredStack) {
        return BuilderAPI.schematicHelper.isEqualItem(suppliedStack, requiredStack);
    }

    public ItemStack useItem(IBuilderContext context, ItemStack req, IInvSlot slot) {
        ItemStack stack = slot.getStackInSlot();
        ItemStack result = stack.copy();
        if (stack.isItemStackDamageable()) {
            if (req.getItemDamage() + stack.getItemDamage() <= stack.getMaxDamage()) {
                stack.setItemDamage(req.getItemDamage() + stack.getItemDamage());
                result.setItemDamage(req.getItemDamage());
                req.stackSize = 0;
            }
            if (stack.getItemDamage() >= stack.getMaxDamage()) {
                slot.decreaseStackInSlot(1);
            }
        } else if (stack.stackSize >= req.stackSize) {
            result.stackSize = req.stackSize;
            stack.stackSize -= req.stackSize;
            req.stackSize = 0;
        } else {
            req.stackSize -= stack.stackSize;
            stack.stackSize = 0;
        }
        if (stack.stackSize == 0) {
            stack.stackSize = 1;
            if (stack.getItem().hasContainerItem(stack)) {
                ItemStack newStack = stack.getItem().getContainerItem(stack);
                slot.setStackInSlot(newStack);
            } else {
                slot.setStackInSlot(null);
            }
        }
        return result;
    }

    public void rotateLeft(IBuilderContext context) {
    }

    public void translateToBlueprint(Translation transform) {
    }

    public void translateToWorld(Translation transform) {
    }

    public void idsToBlueprint(MappingRegistry registry) {
    }

    public void idsToWorld(MappingRegistry registry) {
    }

    public void initializeFromObjectAt(IBuilderContext context, int x, int y, int z) {
    }

    public void placeInWorld(IBuilderContext context, int x, int y, int z, LinkedList<ItemStack> stacks) {
    }

    public void storeRequirements(IBuilderContext context, int x, int y, int z) {
    }

    public void getRequirementsForPlacement(IBuilderContext context, LinkedList<ItemStack> requirements) {
    }

    public int getEnergyRequirement(LinkedList<ItemStack> stacksUsed) {
        int result = 0;
        if (stacksUsed != null) {
            for (ItemStack s : stacksUsed) {
                result += s.stackSize * 240;
            }
        }
        return result;
    }

    public LinkedList<ItemStack> getStacksToDisplay(LinkedList<ItemStack> stackConsumed) {
        return stackConsumed;
    }

    public BuildingStage getBuildStage() {
        return BuildingStage.STANDALONE;
    }

    public boolean isAlreadyBuilt(IBuilderContext context, int x, int y, int z) {
        return true;
    }

    public boolean doNotBuild() {
        return false;
    }

    public boolean doNotUse() {
        return false;
    }

    public BuildingPermission getBuildingPermission() {
        return BuildingPermission.ALL;
    }

    public void postProcessing(IBuilderContext context, int x, int y, int z) {
    }

    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
    }

    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
    }

    public int buildTime() {
        return 1;
    }

    public static enum BuildingStage {
        STANDALONE,
        EXPANDING;

    }
}

