/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.robots;

import buildcraft.api.robots.RobotManager;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ResourceId {
    protected ResourceId() {
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.setString("resourceName", RobotManager.getResourceIdName(this.getClass()));
    }

    protected void readFromNBT(NBTTagCompound nbt) {
    }

    public static ResourceId load(NBTTagCompound nbt) {
        try {
            Class<?> cls = nbt.hasKey("class") ? RobotManager.getResourceIdByLegacyClassName(nbt.getString("class")) : RobotManager.getResourceIdByName(nbt.getString("resourceName"));
            ResourceId id = (ResourceId)cls.newInstance();
            id.readFromNBT(nbt);
            return id;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }
}

