/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.api.core.BCLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.BlockFluidBase;

public class SchematicBlock
extends SchematicBlockBase {
    public IBlockState state = null;
    public BuildingPermission defaultPermission = BuildingPermission.ALL;
    public ItemStack[] storedRequirements = new ItemStack[0];
    private boolean doNotUse = false;

    @Override
    public void getRequirementsForPlacement(IBuilderContext context, List<ItemStack> requirements) {
        if (this.state != null) {
            if (this.storedRequirements.length != 0) {
                Collections.addAll(requirements, this.storedRequirements);
            } else {
                requirements.add(this.getItemStack(this.state));
            }
        }
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, BlockPos pos) {
        IBlockState placed = context.world().func_180495_p(pos);
        if (this.state == placed) {
            return true;
        }
        if (this.state.func_177230_c() != placed.func_177230_c()) {
            return false;
        }
        return this.state.func_177230_c().func_176201_c(this.state) == placed.func_177230_c().func_176201_c(placed);
    }

    @Override
    public void placeInWorld(IBuilderContext context, BlockPos pos, List<ItemStack> stacks) {
        super.placeInWorld(context, pos, stacks);
        this.setBlockInWorld(context, pos);
    }

    @Override
    public void storeRequirements(IBuilderContext context, BlockPos pos) {
        List req;
        super.storeRequirements(context, pos);
        if (this.state != null && (req = this.state.func_177230_c().getDrops((IBlockAccess)context.world(), pos, this.state, 0)) != null) {
            this.storedRequirements = new ItemStack[req.size()];
            req.toArray(this.storedRequirements);
        }
    }

    @Override
    public void writeSchematicToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.writeSchematicToNBT(nbt, registry);
        this.writeBlockToNBT(nbt, registry);
        this.writeRequirementsToNBT(nbt, registry);
    }

    @Override
    public void readSchematicFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        super.readSchematicFromNBT(nbt, registry);
        this.readBlockFromNBT(nbt, registry);
        if (!this.doNotUse()) {
            this.readRequirementsFromNBT(nbt, registry);
        }
    }

    public Set<BlockPos> getPrerequisiteBlocks(IBuilderContext context) {
        HashSet<BlockPos> indexes = new HashSet<BlockPos>();
        if (this.state.func_177230_c() instanceof BlockFalling) {
            indexes.add(new BlockPos(0, -1, 0));
        }
        return indexes;
    }

    @Override
    public Schematic.BuildingStage getBuildStage() {
        if (this.state.func_177230_c() instanceof BlockFluidBase || this.state.func_177230_c() instanceof BlockLiquid) {
            return Schematic.BuildingStage.EXPANDING;
        }
        return Schematic.BuildingStage.STANDALONE;
    }

    @Override
    public BuildingPermission getBuildingPermission() {
        return this.defaultPermission;
    }

    protected void setBlockInWorld(IBuilderContext context, BlockPos pos) {
        context.world().func_180501_a(pos, this.state, 3);
    }

    @Override
    public boolean doNotUse() {
        return this.doNotUse;
    }

    protected void readBlockFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        try {
            Block block = registry.getBlockForId(nbt.func_74762_e("blockId"));
            this.state = block.func_176203_a(nbt.func_74762_e("blockMeta"));
        }
        catch (MappingNotFoundException e) {
            BCLog.logger.info((Object)e);
            this.doNotUse = true;
        }
    }

    protected void readRequirementsFromNBT(NBTTagCompound nbt, MappingRegistry registry) {
        if (nbt.func_74764_b("rq")) {
            NBTTagList rq = nbt.func_150295_c("rq", 10);
            ArrayList<ItemStack> rqs = new ArrayList<ItemStack>();
            for (int i = 0; i < rq.func_74745_c(); ++i) {
                try {
                    NBTTagCompound sub = rq.func_150305_b(i);
                    registry.stackToWorld(sub);
                    rqs.add(ItemStack.func_77949_a((NBTTagCompound)sub));
                    continue;
                }
                catch (MappingNotFoundException e) {
                    this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
                    continue;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    this.defaultPermission = BuildingPermission.CREATIVE_ONLY;
                }
            }
            this.storedRequirements = rqs.toArray(new ItemStack[rqs.size()]);
        } else {
            this.storedRequirements = new ItemStack[0];
        }
    }

    protected void writeBlockToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        nbt.func_74768_a("blockId", registry.getIdForBlock(this.state.func_177230_c()));
        nbt.func_74768_a("blockMeta", this.state.func_177230_c().func_176201_c(this.state));
    }

    protected void writeRequirementsToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        if (this.storedRequirements.length > 0) {
            NBTTagList rq = new NBTTagList();
            for (ItemStack stack : this.storedRequirements) {
                if (stack == null || stack.func_77973_b() == null) {
                    throw new IllegalStateException("Found a null requirement! " + this.getClass());
                }
                NBTTagCompound sub = new NBTTagCompound();
                stack.func_77955_b(sub);
                rq.func_74742_a((NBTBase)sub);
            }
            nbt.func_74782_a("rq", (NBTBase)rq);
        }
    }

    protected ItemStack getItemStack(IBlockState state, int quantity) {
        return new ItemStack(state.func_177230_c(), quantity, state.func_177230_c().func_180651_a(state));
    }

    protected ItemStack getItemStack(IBlockState state) {
        return this.getItemStack(state, 1);
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        IProperty<EnumFacing> facingProp = this.getFacingProp();
        if (facingProp != null) {
            EnumFacing face = (EnumFacing)this.state.func_177229_b(facingProp);
            if (face.func_176740_k() == EnumFacing.Axis.Y) {
                return;
            }
            this.state = this.state.func_177226_a(facingProp, (Comparable)face.func_176746_e());
        }
    }

    protected IProperty<EnumFacing> getFacingProp() {
        Collection props = this.state.func_177227_a();
        for (IProperty prop : props) {
            if (!"facing".equals(prop.func_177701_a()) || !(this.state.func_177229_b(prop) instanceof EnumFacing)) continue;
            return prop;
        }
        return null;
    }
}

