/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.gates;

import buildcraft.api.gates.IExpansionBaker;
import java.util.Arrays;
import net.minecraft.util.EnumWorldBlockLayer;

public class GateExpansionModelKey<K extends GateExpansionModelKey<K>> {
    public final EnumWorldBlockLayer layer;
    public final IExpansionBaker<K> baker;
    private final int hash;

    public GateExpansionModelKey(EnumWorldBlockLayer layer, IExpansionBaker<K> baker) {
        if (layer != EnumWorldBlockLayer.CUTOUT && layer != EnumWorldBlockLayer.TRANSLUCENT) {
            throw new IllegalArgumentException("Unsuported layer! Was " + layer + ", wanted CUTOUT or TRANSLUCENT");
        }
        if (baker == null) {
            throw new NullPointerException("baker");
        }
        this.layer = layer;
        this.baker = baker;
        this.hash = Arrays.hashCode(new int[]{layer.hashCode(), System.identityHashCode(baker)});
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GateExpansionModelKey other = (GateExpansionModelKey)obj;
        return this.baker == other.baker;
    }
}

