/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe_bc8;

import buildcraft.api.ObjectDefinition;
import buildcraft.api.core.BCLog;
import buildcraft.api.transport.pipe_bc8.IPipeBehaviourFactory;
import buildcraft.api.transport.pipe_bc8.IPipeType;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PipeDefinition_BC8
extends ObjectDefinition {
    public final int maxSprites;
    public final String textureLocationStart;
    private final String[] spriteLocations;
    public final IPipeBehaviourFactory behaviourFactory;
    public final IPipeType type;
    @SideOnly(value=Side.CLIENT)
    private TextureAtlasSprite[] sprites;
    public final int itemSpriteIndex;

    public PipeDefinition_BC8(String tag, IPipeType type, String textureStart, String[] textureSuffixes, IPipeBehaviourFactory behaviour) {
        this(tag, type, 0, textureStart, textureSuffixes, behaviour);
    }

    public PipeDefinition_BC8(String tag, IPipeType type, int itemSpriteIndex, String textureStart, String[] textureSuffixes, IPipeBehaviourFactory factory) {
        super(tag);
        this.type = type;
        this.maxSprites = textureSuffixes == null ? 1 : textureSuffixes.length;
        this.itemSpriteIndex = itemSpriteIndex;
        this.textureLocationStart = textureStart.endsWith("/") ? textureStart : textureStart + "/";
        this.spriteLocations = new String[this.maxSprites];
        for (int i = 0; i < this.maxSprites; ++i) {
            this.spriteLocations[i] = this.textureLocationStart + this.modUniqueTag + (textureSuffixes == null ? "" : textureSuffixes[i]);
        }
        this.behaviourFactory = factory;
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getSprite(int index) {
        if (this.sprites == null || index < 0 || index >= this.sprites.length) {
            BCLog.logger.warn("Tried to get the sprite index " + index + " for " + this.globalUniqueTag);
            return Minecraft.func_71410_x().func_147117_R().func_174944_f();
        }
        return this.sprites[index];
    }

    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureMap map) {
        this.sprites = new TextureAtlasSprite[this.maxSprites];
        for (int i = 0; i < this.spriteLocations.length; ++i) {
            String string = this.spriteLocations[i];
            ResourceLocation location = new ResourceLocation(string);
            this.sprites[i] = map.func_174942_a(location);
        }
    }

    public String toString() {
        return "PipeDefinition [globalUniqueTag=" + this.globalUniqueTag + ", modUniqueTag=" + this.modUniqueTag + ", behaviourFactory=" + this.behaviourFactory + ", type=" + this.type + ", spriteLocations=" + Arrays.toString(this.spriteLocations) + "]";
    }
}

