/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.BuildCraftBuilders;
import buildcraft.core.GuiIds;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.fluids.TankUtils;

public class BlockBuilder extends BlockBuildCraft {
    public BlockBuilder() {
        super(Material.field_151573_f, FACING_PROP, LED_DONE, LED_POWER, BLUEPRINT_TYPE);
        func_149711_c(5F);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        state = super.func_176221_a(state, access, pos);
        TileEntity tile = access.func_175625_s(pos);
        if (tile != null && tile instanceof TileBuilder) {
            state = state.func_177226_a(BLUEPRINT_TYPE, ((TileBuilder) tile).getType());
        }
        return state;
    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileBuilder();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing side, float hitX, float hitY,
            float hitZ) {
        if (super.func_180639_a(world, pos, state, entityplayer, side, hitX, hitY, hitZ)) {
            return true;
        }

        if (entityplayer.func_70093_af()) {
            return false;
        }

        TileEntity tile = world.func_175625_s(pos);
        TileBuilder builder = tile instanceof TileBuilder ? (TileBuilder) tile : null;

        Item equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;
        if (equipped instanceof ItemConstructionMarker) {
            if (ItemConstructionMarker.linkStarted(entityplayer.func_71045_bC())) {
                ItemConstructionMarker.link(entityplayer.func_71045_bC(), world, pos);
            }

            return true;
        } else if (builder != null && TankUtils.handleRightClick(builder, null, entityplayer, true, false)) {
            return true;
        } else {
            if (!world.field_72995_K) {
                entityplayer.openGui(BuildCraftBuilders.instance, GuiIds.BUILDER, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }

            return true;
        }
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return 1;
    }

    @Override
    @SideOnly(Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }
}
