/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.BlockMarker;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;

public class BlockConstructionMarker extends BlockMarker {
    public BlockConstructionMarker() {}

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileConstructionMarker();
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Utils.preDestroyBlock(world, pos);
        dropMarkerIfPresent(world, pos, true);
        super.func_180663_b(world, pos, state);
    }

    private boolean dropMarkerIfPresent(World world, BlockPos pos, boolean onBreak) {
        TileConstructionMarker marker = (TileConstructionMarker) world.func_175625_s(pos);
        if (marker != null && marker.itemBlueprint != null && !world.field_72995_K) {
            BlockUtils.dropItem((WorldServer) world, pos, 6000, marker.itemBlueprint);
            marker.itemBlueprint = null;
            if (!onBreak) {
                marker.bluePrintBuilder = null;
                marker.bptContext = null;
                marker.sendNetworkUpdate();
            }
            return true;
        }
        return false;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityliving, ItemStack stack) {
        super.func_180633_a(world, pos, state, entityliving, stack);

        TileConstructionMarker tile = (TileConstructionMarker) world.func_175625_s(pos);
        tile.direction = entityliving.func_174811_aO();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityplayer, EnumFacing face, float hitX, float hitY,
            float hitZ) {
        if (super.func_180639_a(world, pos, state, entityplayer, face, hitX, hitY, hitZ)) {
            return true;
        }

        TileConstructionMarker marker = (TileConstructionMarker) world.func_175625_s(pos);

        Item equipped = entityplayer.func_71045_bC() != null ? entityplayer.func_71045_bC().func_77973_b() : null;

        if (equipped instanceof ItemBlueprint) {
            if (marker.itemBlueprint == null) {
                ItemStack stack = entityplayer.field_71071_by.func_70448_g().func_77946_l();
                stack.field_77994_a = 1;
                marker.setBlueprint(stack);
                stack = null;
                if (entityplayer.field_71071_by.func_70448_g().field_77994_a > 1) {
                    stack = entityplayer.func_71045_bC().func_77946_l();
                    stack.field_77994_a = entityplayer.func_71045_bC().field_77994_a - 1;
                }
                entityplayer.field_71071_by.func_70299_a(entityplayer.field_71071_by.field_70461_c, stack);

                return true;
            }
        } else if (equipped instanceof ItemConstructionMarker) {
            if (ItemConstructionMarker.linkStarted(entityplayer.func_71045_bC())) {
                ItemConstructionMarker.link(entityplayer.func_71045_bC(), world, pos);
                return true;
            }
        } else if ((equipped == null || equipped instanceof IToolWrench) && entityplayer.func_70093_af()) {
            return dropMarkerIfPresent(world, pos, false);
        }

        return false;
    }
}
