/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.BuildCraftBuilders;
import buildcraft.core.GuiIds;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.lib.block.BlockBuildCraft;

public class BlockFiller extends BlockBuildCraft {
    public BlockFiller() {
        super(Material.field_151573_f, FACING_PROP, LED_DONE, LED_POWER, FILLER_PATTERN);
        func_149711_c(5F);
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing face, float par7, float par8,
            float par9) {
        if (super.func_180639_a(world, pos, state, player, face, par7, par8, par9)) {
            return true;
        }

        if (player.func_70093_af()) {
            return false;
        }

        if (!world.field_72995_K) {
            player.openGui(BuildCraftBuilders.instance, GuiIds.FILLER, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;

    }

    @Override
    public TileEntity func_149915_a(World world, int metadata) {
        return new TileFiller();
    }

    @Override
    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        return 1;
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        state = super.func_176221_a(state, access, pos);
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileFiller) {
            FillerPattern pattern = ((TileFiller) tile).currentPattern;
            if (pattern == null) {
                return state;
            } else {
                state = state.func_177226_a(FILLER_PATTERN, pattern.type);
                return state;
            }
        } else {
            return state;
        }
    }

    @Override
    @SideOnly(Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }
}
