/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

import buildcraft.core.lib.EntityResizableCuboid;

import io.netty.buffer.ByteBuf;

public class EntityMechanicalArm extends Entity implements IEntityAdditionalSpawnData {

    protected TileQuarry parent;

    private double armSizeX;
    private double armSizeZ;
    private Vec3 root, head;

    /** Public for the renderer */
    public EntityResizableCuboid xArm, yArm, zArm, headEntity;

    public EntityMechanicalArm(World world) {
        super(world);
        makeParts(world);
        field_70145_X = true;
    }

    public EntityMechanicalArm(World world, Vec3 root, double width, double height, TileQuarry parent) {
        this(world);
        func_70080_a(parent.func_174877_v().func_177958_n(), parent.func_174877_v().func_177956_o(), parent.func_174877_v().func_177952_p(), 0, 0);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.root = root;
        setHead(root.func_72441_c(0, -2, 0));
        setArmSize(width, height);
        this.parent = parent;
        parent.setArm(this);
        updatePosition();
    }

    public void setHead(Vec3 vec) {
        this.head = vec;
    }

    private void setArmSize(double x, double z) {
        armSizeX = x;
        xArm.xSize = x;
        armSizeZ = z;
        zArm.zSize = z;
        updatePosition();
    }

    private void makeParts(World world) {
        xArm = BuilderProxy.proxy.newDrill(world, 0, 0, 0, 1, 0.5, 0.5);
        yArm = BuilderProxy.proxy.newDrill(world, 0, 0, 0, 0.5, 1, 0.5);
        zArm = BuilderProxy.proxy.newDrill(world, 0, 0, 0, 0.5, 0.5, 1);

        headEntity = BuilderProxy.proxy.newDrillHead(world, 0, 0, 0, 0.2, 1, 0.2);
        headEntity.shadowSize = 1.0F;

        // world.spawnEntityInWorld(xArm);
        // world.spawnEntityInWorld(yArm);
        // world.spawnEntityInWorld(zArm);
        // world.spawnEntityInWorld(headEntity);
    }

    @Override
    protected void func_70088_a() {}

    @Override
    protected void func_70037_a(NBTTagCompound nbttagcompound) {
        double xRoot = nbttagcompound.func_74769_h("xRoot");
        double yRoot = nbttagcompound.func_74769_h("yRoot");
        double zRoot = nbttagcompound.func_74769_h("zRoot");
        root = new Vec3(xRoot, yRoot, zRoot);
        armSizeX = nbttagcompound.func_74769_h("armSizeX");
        armSizeZ = nbttagcompound.func_74769_h("armSizeZ");
        setArmSize(armSizeX, armSizeZ);
        updatePosition();
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74780_a("xRoot", root.field_72450_a);
        nbttagcompound.func_74780_a("yRoot", root.field_72448_b);
        nbttagcompound.func_74780_a("zRoot", root.field_72449_c);
        nbttagcompound.func_74780_a("armSizeX", armSizeX);
        nbttagcompound.func_74780_a("armSizeZ", armSizeZ);
    }

    @Override
    public void readSpawnData(ByteBuf buffer) {
        root = new Vec3(buffer.readDouble(), buffer.readDouble(), buffer.readDouble());
        armSizeX = buffer.readDouble();
        armSizeZ = buffer.readDouble();
        setArmSize(armSizeX, armSizeZ);
        updatePosition();
    }

    @Override
    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeDouble(root.field_72450_a);
        buffer.writeDouble(root.field_72448_b);
        buffer.writeDouble(root.field_72449_c);
        buffer.writeDouble(armSizeX);
        buffer.writeDouble(armSizeZ);
    }

    private void findAndJoinQuarry() {
        TileEntity te = field_70170_p.func_175625_s(new BlockPos((int) field_70165_t, (int) field_70163_u, (int) field_70161_v));
        if (te instanceof TileQuarry) {
            parent = (TileQuarry) te;
            parent.setArm(this);
        } else {
            func_70106_y();
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        updatePosition();
        if (parent == null || parent.arm != this) {
            findAndJoinQuarry();
        }

        if (parent == null) {
            func_70106_y();
            return;
        }
        xArm.func_70071_h_();
        yArm.func_70071_h_();
        zArm.func_70071_h_();
        headEntity.func_70071_h_();
    }

    public void updatePosition() {
        if (root == null || head == null) return;
        // HEAD MAY BE NULL!
        this.xArm.func_70107_b(root.field_72450_a, root.field_72448_b, head.field_72449_c + 0.25);
        this.yArm.ySize = root.field_72448_b - head.field_72448_b - 1;
        this.yArm.func_70107_b(head.field_72450_a + 0.25, head.field_72448_b + 1, head.field_72449_c + 0.25);
        this.zArm.func_70107_b(head.field_72450_a + 0.25, root.field_72448_b, root.field_72449_c);
        this.headEntity.func_70107_b(head.field_72450_a + 0.4, head.field_72448_b - 0.01, head.field_72449_c + 0.4);
    }

    @Override
    public void func_70106_y() {
        if (field_70170_p != null && field_70170_p.field_72995_K) {
            xArm.func_70106_y();
            yArm.func_70106_y();
            zArm.func_70106_y();
            headEntity.func_70106_y();
        }
        super.func_70106_y();
    }
}
