/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders;

import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;

public class ItemConstructionMarker extends ItemBlock {

    @SideOnly(Side.CLIENT)
    public TextureAtlasSprite iconBase;

    @SideOnly(Side.CLIENT)
    public TextureAtlasSprite iconRecording;

    public ItemConstructionMarker(Block block) {
        super(block);
    }

    public static boolean linkStarted(ItemStack marker) {
        return NBTUtils.getItemData(marker).func_74764_b("x");
    }

    public static void link(ItemStack marker, World world, BlockPos pos) {
        NBTTagCompound nbt = NBTUtils.getItemData(marker);

        if (nbt.func_74764_b("x")) {
            int ox = nbt.func_74762_e("x");
            int oy = nbt.func_74762_e("y");
            int oz = nbt.func_74762_e("z");

            TileEntity tile1 = world.func_175625_s(new BlockPos(ox, oy, oz));

            // TODO (CHECK) is this right?
            if (!(new Vec3(ox, oy, oz).func_72436_e(Utils.convert(pos)) > 64)) {
                return;
            }

            if (tile1 != null && (tile1 instanceof TileArchitect)) {
                TileArchitect architect = (TileArchitect) tile1;
                TileEntity tile2 = world.func_175625_s(pos);

                if (tile1 != tile2 && tile2 != null) {
                    if (tile2 instanceof TileArchitect || tile2 instanceof TileConstructionMarker || tile2 instanceof TileBuilder) {
                        architect.addSubBlueprint(tile2);

                        nbt.func_82580_o("x");
                        nbt.func_82580_o("y");
                        nbt.func_82580_o("z");
                    }
                }

                return;
            }
        }

        nbt.func_74768_a("x", pos.func_177958_n());
        nbt.func_74768_a("y", pos.func_177956_o());
        nbt.func_74768_a("z", pos.func_177952_p());
    }

    @Override
    public boolean func_180614_a(ItemStack marker, EntityPlayer player, World world, BlockPos pos, EnumFacing facing, float par8, float par9,
            float par10) {

        TileEntity tile = world.func_175625_s(pos);
        NBTTagCompound nbt = NBTUtils.getItemData(marker);

        if (nbt.func_74764_b("x") && !(tile instanceof TileBuilder || tile instanceof TileArchitect || tile instanceof TileConstructionMarker)) {

            nbt.func_82580_o("x");
            nbt.func_82580_o("y");
            nbt.func_82580_o("z");

            return true;
        } else {
            return super.func_180614_a(marker, player, world, pos, facing, par8, par9, par10);
        }
    }
}
