/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders.gui;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

import buildcraft.builders.TileBuilder;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.widgets.ScrollbarWidget;

public class ContainerBuilder extends BuildCraftContainer {
    IInventory playerInventory;
    TileBuilder builder;
    protected ScrollbarWidget scrollbarWidget;

    public ContainerBuilder(EntityPlayer player, TileBuilder builder) {
        super(player, builder.func_70302_i_());
        this.playerInventory = player.field_71071_by;
        this.builder = builder;

        this.scrollbarWidget = new ScrollbarWidget(172, 17, 18, 0, 108);
        this.scrollbarWidget.hidden = true;
        this.addWidget(scrollbarWidget);

        func_75146_a(new Slot(builder, 0, 80, 27));

        for (int k = 0; k < 3; k++) {
            for (int j1 = 0; j1 < 9; j1++) {
                func_75146_a(new Slot(builder, 1 + j1 + k * 9, 8 + j1 * 18, 72 + k * 18));
            }
        }

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 9; x++) {
                func_75146_a(new Slot(playerInventory, x + y * 9 + 9, 8 + x * 18, 140 + y * 18));
            }
        }

        for (int x = 0; x < 9; x++) {
            func_75146_a(new Slot(playerInventory, x, 8 + x * 18, 198));
        }

        if (!builder.func_145831_w().field_72995_K && playerInventory instanceof InventoryPlayer) {
            // Refresh the requirements list for the player opening the GUI,
            // in case he does not have it.
            builder.updateRequirementsOnGuiOpen(((InventoryPlayer) playerInventory).field_70458_d);
            builder.addGuiWatcher(((InventoryPlayer) playerInventory).field_70458_d);
        }
    }

    public TileBuilder getBuilder() {
        return builder;
    }

    @Override
    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        builder.removeGuiWatcher(player);
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityplayer) {
        return builder.func_70300_a(entityplayer);
    }

}
