/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders.gui;

import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

import buildcraft.builders.TileFiller;
import buildcraft.core.lib.gui.BuildCraftContainer;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.widgets.Widget;

public class ContainerFiller extends BuildCraftContainer {

    IInventory playerInventory;
    TileFiller tile;

    private class PatternWidget extends Widget {

        public PatternWidget() {
            super(38, 30, 0, 0, 16, 16);
        }

        @SideOnly(Side.CLIENT)
        @Override
        public void draw(GuiBuildCraft gui, int guiX, int guiY, int mouseX, int mouseY) {
            gui.bindTexture(TextureMap.field_110575_b);
            gui.func_175175_a(guiX + x, guiY + y, tile.currentPattern.getGuiSprite(), 16, 16);
        }
    }

    public ContainerFiller(EntityPlayer player, TileFiller tile) {
        super(player, tile.func_70302_i_());
        this.playerInventory = player.field_71071_by;
        this.tile = tile;

        addWidget(new PatternWidget());

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 9; x++) {
                func_75146_a(new Slot(tile, x + y * 9, 8 + x * 18, 85 + y * 18));
            }
        }

        for (int y = 0; y < 3; y++) {
            for (int x = 0; x < 9; x++) {
                func_75146_a(new Slot(playerInventory, x + y * 9 + 9, 8 + x * 18, 153 + y * 18));
            }

        }

        for (int x = 0; x < 9; x++) {
            func_75146_a(new Slot(playerInventory, x, 8 + x * 18, 211));
        }
    }

    @Override
    public boolean func_75145_c(EntityPlayer entityplayer) {
        return tile.func_70300_a(entityplayer);
    }
}
