/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders.gui;

import java.io.IOException;

import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

import buildcraft.builders.TileArchitect;
import buildcraft.BuildCraftCore;
import buildcraft.core.DefaultProps;
import buildcraft.core.blueprints.BlueprintReadConfiguration;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.buttons.GuiBetterButton;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.BCStringUtils;

import io.netty.buffer.ByteBuf;

public class GuiArchitect extends GuiBuildCraft {

    private static final int TEXT_X = 90;
    private static final int TEXT_Y = 62;
    private static final int TEXT_WIDTH = 156;
    private static final int TEXT_HEIGHT = 12;

    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/architect_gui.png");

    private TileArchitect architect;

    private GuiBetterButton optionRotate;
    private GuiBetterButton optionExcavate;
    private GuiBetterButton optionAllowCreative;

    private GuiTextField textField;

    public GuiArchitect(EntityPlayer player, TileArchitect architect) {
        super(new ContainerArchitect(player, architect), architect, TEXTURE);
        this.architect = architect;
        field_146999_f = 256;
        field_147000_g = 166;
    }

    @SuppressWarnings("unchecked")
    @Override
    public void func_73866_w_() {
        super.func_73866_w_();

        Keyboard.enableRepeatEvents(true);

        optionRotate = new GuiBetterButton(0, field_147003_i + 5, field_147009_r + 30, 79, "");
        field_146292_n.add(optionRotate);

        optionExcavate = new GuiBetterButton(1, field_147003_i + 5, field_147009_r + 55, 79, "");
        field_146292_n.add(optionExcavate);

        optionAllowCreative = new GuiBetterButton(2, field_147003_i + 5, field_147009_r + 80, 79, "");
        optionAllowCreative.setToolTip(new ToolTip(500, new ToolTipLine(BCStringUtils.localize("tile.architect.tooltip.allowCreative.1")),
                new ToolTipLine(BCStringUtils.localize("tile.architect.tooltip.allowCreative.2"))));
        field_146292_n.add(optionAllowCreative);

        textField = new GuiTextField(0, this.field_146289_q, TEXT_X, TEXT_Y, TEXT_WIDTH, TEXT_HEIGHT);
        textField.func_146203_f(DefaultProps.MAX_NAME_SIZE);
        textField.func_146180_a(architect.name);
        textField.func_146195_b(true);

        updateButtons();
    }

    @Override
    public void func_146281_b() {
        Keyboard.enableRepeatEvents(false);
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        BlueprintReadConfiguration conf = architect.readConfiguration;

        if (button == optionRotate) {
            conf.rotate = !conf.rotate;
        } else if (button == optionExcavate) {
            conf.excavate = !conf.excavate;
        } else if (button == optionAllowCreative) {
            conf.allowCreative = !conf.allowCreative;
        }

        architect.rpcSetConfiguration(conf);

        updateButtons();
    }

    private void updateButtons() {
        BlueprintReadConfiguration conf = architect.readConfiguration;

        if (conf.rotate) {
            optionRotate.field_146126_j = BCStringUtils.localize("tile.architect.rotate");
        } else {
            optionRotate.field_146126_j = BCStringUtils.localize("tile.architect.norotate");
        }

        if (conf.excavate) {
            optionExcavate.field_146126_j = BCStringUtils.localize("tile.architect.excavate");
        } else {
            optionExcavate.field_146126_j = BCStringUtils.localize("tile.architect.noexcavate");
        }

        if (conf.allowCreative) {
            optionAllowCreative.field_146126_j = BCStringUtils.localize("tile.architect.allowCreative");
        } else {
            optionAllowCreative.field_146126_j = BCStringUtils.localize("tile.architect.noallowCreative");
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = BCStringUtils.localize("tile.architectBlock.name");
        field_146289_q.func_78276_b(title, getCenteredOffset(title), 6, 0x404040);

        /* if (editMode && ((new Date()).getTime() / 100) % 8 >= 4) { fontRendererObj.drawString(architect.name + "|",
         * 131, 62, 0x404040); } else { fontRendererObj.drawString(architect.name, 131, 62, 0x404040); } */

        textField.func_146194_f();
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);
        int i1 = ((ContainerArchitect) container).computingTime;
        func_73729_b(field_147003_i + 159, field_147009_r + 34, 0, 166, i1 + 1, 16);
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);

        textField.func_146192_a(mouseX - field_147003_i, mouseY - field_147009_r, mouseButton);
    }

    @Override
    protected void func_73869_a(char c, int i) throws IOException {
        if (textField.func_146206_l()) {
            if (c == 13 || c == 27) {
                textField.func_146195_b(false);
            } else {
                textField.func_146201_a(c, i);
                final String text = textField.func_146179_b();
                BuildCraftCore.instance.sendToServer(new PacketCommand(architect, "setName", new CommandWriter() {
                    @Override
                    public void write(ByteBuf data) {
                        NetworkUtils.writeUTF(data, text);
                    }
                }));
            }
        } else {
            super.func_73869_a(c, i);
        }
    }
}
