package buildcraft.builders.gui;

import java.io.IOException;

import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.lwjgl.input.Mouse;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.Template;
import buildcraft.core.lib.world.FakeWorld;
import buildcraft.core.lib.world.FakeWorldManager;

public abstract class GuiBlueprintBase extends GuiScreen {
    protected final BlueprintBase blueprint;
    private final FakeWorldManager fakeWorld;
    private float scroll = 16;
    private BlockPos offset = new BlockPos(0, 0, 0);
    private double mouseX = 0, mouseY = 0;
    private boolean hasRendered = false;

    public GuiBlueprintBase(BlueprintBase blueprint) {
        this.blueprint = blueprint;
        FakeWorld world;
        if (blueprint instanceof Blueprint) {
            world = new FakeWorld((Blueprint) blueprint);
        } else {
            world = new FakeWorld((Template) blueprint, Blocks.field_150336_V.func_176223_P());
        }
        fakeWorld = new FakeWorldManager(world);
        // This is set later, but just set it now to be able to use it earlier
        field_146297_k = Minecraft.func_71410_x();
        MinecraftForge.EVENT_BUS.register(this);
    }

    @SubscribeEvent
    public void openGui(GuiOpenEvent event) {
        if (event.gui != this) {
            field_146297_k.field_71417_B.func_74373_b();
            MinecraftForge.EVENT_BUS.unregister(this);
        }
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!hasRendered) {
            field_146297_k.field_71417_B.func_74372_a();
            hasRendered = true;
        }
        fakeWorld.renderWorld(this.mouseX, this.mouseY, scroll, offset);
    }

    @Override
    public void func_146274_d() throws IOException {
        super.func_146274_d();
        double deltaWheel = Mouse.getEventDWheel() / 64;
        scroll -= deltaWheel;
        if (scroll < 2) {
            scroll += deltaWheel;
        }

        // Same formula as used by minecraft everywhere. No idea if its a special one for general mouse sensitivity or
        // minecraft specific though.
        double sensitivity = field_146297_k.field_71474_y.field_74341_c * 0.6 + 0.2;
        sensitivity *= sensitivity * sensitivity * 0.8;

        mouseX += Mouse.getEventDX() * sensitivity;
        mouseY += Mouse.getEventDY() * sensitivity;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        EnumFacing currentLookFace = EnumFacing.func_176733_a(mouseX);
        if (keyCode == field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            offset = offset.func_177972_a(currentLookFace.func_176734_d());
        } else if (keyCode == field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            offset = offset.func_177972_a(currentLookFace);
        } else if (keyCode == field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            offset = offset.func_177972_a(currentLookFace.func_176746_e());
        } else if (keyCode == field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            offset = offset.func_177972_a(currentLookFace.func_176746_e().func_176734_d());
        } else if (func_146271_m() && !func_146272_n()) {
            offset = offset.func_177977_b();
        } else if (func_146272_n() && !func_146271_m()) {
            offset = offset.func_177984_a();
        }
    }
}
