/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders.gui;

import java.io.IOException;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

import buildcraft.api.library.LibraryAPI;
import buildcraft.builders.TileBlueprintLibrary;
import buildcraft.core.DefaultProps;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.utils.BCStringUtils;

public class GuiBlueprintLibrary extends GuiBuildCraft {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/library_rw.png");
    private GuiButton deleteButton;
    private TileBlueprintLibrary library;

    public GuiBlueprintLibrary(EntityPlayer player, TileBlueprintLibrary library) {
        super(new ContainerBlueprintLibrary(player, library), library, TEXTURE);
        field_146999_f = 244;
        field_147000_g = 220;

        this.library = library;
    }

    @SuppressWarnings("unchecked")
    @Override
    public void func_73866_w_() {
        super.func_73866_w_();

        deleteButton = new GuiButton(2, field_147003_i + 174, field_147009_r + 109, 25, 20, BCStringUtils.localize("gui.del"));
        field_146292_n.add(deleteButton);

        library.refresh();

        checkDelete();
    }

    private ContainerBlueprintLibrary getLibraryContainer() {
        return (ContainerBlueprintLibrary) getContainer();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        String title = BCStringUtils.localize("tile.libraryBlock.name");
        field_146289_q.func_78276_b(title, getCenteredOffset(title), 6, 0x404040);

        int off = getLibraryContainer().scrollbarWidget.getPosition();
        for (int i = off; i < (off + 12); i++) {
            if (i >= library.entries.size()) {
                break;
            }
            LibraryId bpt = library.entries.get(i);
            String name = bpt.name;

            if (name.length() > DefaultProps.MAX_NAME_SIZE) {
                name = name.substring(0, DefaultProps.MAX_NAME_SIZE);
            }

            if (i == library.selected) {
                int l1 = 8;
                int i2 = 22;

                func_73733_a(l1, i2 + 9 * (i - off), l1 + 146, i2 + 9 * (i - off + 1), 0x80ffffff, 0x80ffffff);
            }

            while (field_146289_q.func_78256_a(name) > (160 - 9)) {
                name = name.substring(0, name.length() - 1);
            }

            field_146289_q.func_78276_b(name, 9, 23 + 9 * (i - off), LibraryAPI.getHandlerFor(bpt.extension).getTextColor());
        }
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f(1.0F, 1.0F, 1.0F, 1.0F);
        field_146297_k.field_71446_o.func_110577_a(TEXTURE);

        func_73729_b(field_147003_i, field_147009_r, 0, 0, field_146999_f, field_147000_g);

        getLibraryContainer().scrollbarWidget.hidden = library.entries.size() <= 12;
        getLibraryContainer().scrollbarWidget.setLength(Math.max(0, library.entries.size() - 12));

        drawWidgets(x, y);

        int inP = library.progressIn * 22 / 100;
        int outP = library.progressOut * 22 / 100;

        func_73729_b(field_147003_i + 194 + 22 - inP, field_147009_r + 57, 234 + 22 - inP, 240, inP, 16);
        func_73729_b(field_147003_i + 194, field_147009_r + 79, 234, 224, outP, 16);
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (deleteButton != null && button == deleteButton) {
            library.deleteSelectedBpt();
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        int x = mouseX - field_147003_i;
        int y = mouseY - field_147009_r;

        if (x >= 8 && x <= 161) {
            int ySlot = (y - 22) / 9 + getLibraryContainer().scrollbarWidget.getPosition();

            if (ySlot > -1 && ySlot < library.entries.size()) {
                library.selectBlueprint(ySlot);
            }
        }

        checkDelete();
    }

    protected void checkDelete() {
        if (library.selected != -1) {
            deleteButton.field_146124_l = true;
        } else {
            deleteButton.field_146124_l = false;
        }
    }
}
