/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders.gui;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;

import buildcraft.BuildCraftCore;
import buildcraft.api.tiles.IControllable.Mode;
import buildcraft.builders.TileBuilder;
import buildcraft.core.blueprints.RequirementItemStack;
import buildcraft.core.client.CoreIconProvider;
import buildcraft.core.lib.config.OverridableConfigOption;
import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.BCStringUtils;

import io.netty.buffer.ByteBuf;

public class GuiBuilder extends GuiAdvancedInterface {

    /** Options for controlling the position of extra icons are laid out */
    private static final OverridableConfigOption OPTION_EXTRA_X_POS = new OverridableConfigOption("gui.builder", "extra.x", "80");
    private static final OverridableConfigOption OPTION_EXTRA_Y_POS = new OverridableConfigOption("gui.builder", "extra.y", "44");

    private static final ResourceLocation REGULAR_TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/builder.png");
    private static final ResourceLocation BLUEPRINT_TEXTURE = new ResourceLocation("buildcraftbuilders:textures/gui/builder_blueprint.png");
    private TileBuilder builder;
    private GuiButton selectedButton;

    public GuiBuilder(EntityPlayer player, TileBuilder builder) {
        super(new ContainerBuilder(player, builder), builder, BLUEPRINT_TEXTURE);
        this.builder = builder;
        field_146999_f = 256;
        field_147000_g = 225;

        resetNullSlots(6 * 4);

        for (int i = 0; i < 6; ++i) {
            for (int j = 0; j < 4; ++j) {
                slots.set(i * 4 + j, new SlotBuilderRequirement(this, 179 + j * 18, 18 + i * 18));
            }
        }
    }

    private ContainerBuilder getContainerBuilder() {
        return (ContainerBuilder) getContainer();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);

        drawCenteredString(BCStringUtils.localize("tile.builderBlock.name"), 178 / 2, 16, 0x404040);
        if (builder.func_70301_a(0) != null) {
            field_146289_q.func_78276_b(BCStringUtils.localize("gui.building.resources"), 8, 60, 0x404040);
            field_146289_q.func_78276_b(BCStringUtils.localize("gui.inventory"), 8, field_147000_g - 97, 0x404040);
            field_146289_q.func_78276_b(BCStringUtils.localize("gui.needed"), 178, 7, 0x404040);
            field_146289_q.func_78276_b(BCStringUtils.localize("gui.building.fluids"), 178, 133, 0x404040);
        }

        drawTooltips(par1, par2);
        GlStateManager.func_179131_c(1f, 1f, 1f, 1f);
    }

    private void drawTooltips(int par1, int par2) {
        int top = field_147009_r + 145;
        for (int i = 0; i < builder.fluidTanks.length; i++) {
            int left = field_147003_i + 179 + 18 * i;
            if (par1 >= left && par2 >= top && par1 < (left + 16) && par2 < (left + 47)) {
                List<String> fluidTip = new ArrayList<>();
                Tank tank = builder.fluidTanks[i];
                if (tank.getFluid() != null && tank.getFluid().amount > 0) {
                    fluidTip.add(tank.getFluid().getLocalizedName());
                    if (!BuildCraftCore.hideFluidNumbers) {
                        fluidTip.add(EnumChatFormatting.GRAY + "" + EnumChatFormatting.ITALIC + tank.getFluid().amount + " mB");
                    }
                } else {
                    fluidTip.add(StatCollector.func_74838_a("gui.fluidtank.empty"));
                }
                drawHoveringText(fluidTip, par1 - field_147003_i, par2 - field_147009_r, field_146289_q);
                return;
            }
        }

        drawTooltipForSlotAt(par1, par2);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        // We cannot do super here due to some crazy shenanigans with a dynamically
        // resized GUI.
        GlStateManager.func_179131_c(1f, 1f, 1f, 1f);
        boolean isBlueprint = builder.func_70301_a(0) != null;

        field_146297_k.field_71446_o.func_110577_a(REGULAR_TEXTURE);
        func_73729_b(field_147003_i, field_147009_r, 0, 0, 176, field_147000_g);
        field_146297_k.field_71446_o.func_110577_a(BLUEPRINT_TEXTURE);
        if (isBlueprint) {
            func_73729_b(field_147003_i + 169, field_147009_r, 169, 0, 256 - 169, field_147000_g);
        }

        List<RequirementItemStack> needs = builder.getNeededItems();

        if (needs != null) {
            if (needs.size() > slots.size()) {
                getContainerBuilder().scrollbarWidget.hidden = false;
                getContainerBuilder().scrollbarWidget.setLength((needs.size() - slots.size() + 3) / 4);
            } else {
                getContainerBuilder().scrollbarWidget.hidden = true;
            }

            int offset = getContainerBuilder().scrollbarWidget.getPosition() * 4;
            for (int s = 0; s < slots.size(); s++) {
                int ts = offset + s;
                if (ts >= needs.size()) {
                    ((SlotBuilderRequirement) slots.get(s)).stack = null;
                } else {
                    ((SlotBuilderRequirement) slots.get(s)).stack = needs.get(ts);
                }
            }

            for (GuiButton b : (List<GuiButton>) field_146292_n) {
                b.field_146125_m = true;
            }
        } else {
            getContainerBuilder().scrollbarWidget.hidden = true;
            for (AdvancedSlot slot : slots) {
                ((SlotBuilderRequirement) slot).stack = null;
            }
            for (GuiButton b : (List<GuiButton>) field_146292_n) {
                b.field_146125_m = false;
            }
        }

        if (builder.getControlMode() == Mode.Off) {
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            int extraX = field_147003_i + OPTION_EXTRA_X_POS.getAsInt();
            int extraY = field_147009_r + OPTION_EXTRA_Y_POS.getAsInt();
            func_175175_a(extraX, extraY, CoreIconProvider.TURNED_OFF.getSprite(), 16, 16);
        }

        drawWidgets(x, y);

        if (isBlueprint) {
            drawBackgroundSlots(x, y);

            for (int i = 0; i < builder.fluidTanks.length; i++) {
                Tank tank = builder.fluidTanks[i];
                if (tank.getFluid() != null && tank.getFluid().amount > 0) {
                    drawFluid(tank.getFluid(), field_147003_i + 179 + 18 * i, field_147009_r + 145, 16, 47, tank.getCapacity());
                }
            }

            field_146297_k.field_71446_o.func_110577_a(BLUEPRINT_TEXTURE);

            for (int i = 0; i < builder.fluidTanks.length; i++) {
                Tank tank = builder.fluidTanks[i];
                if (tank.getFluid() != null && tank.getFluid().amount > 0) {
                    func_73729_b(field_147003_i + 179 + 18 * i, field_147009_r + 145, 0, 54, 16, 47);
                }
            }
        }
        GlStateManager.func_179131_c(1f, 1f, 1f, 1f);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        for (int i = 0; i < 4; i++) {
            field_146292_n.add(new BuilderEraseButton(i, field_147003_i + 178 + 18 * i, field_147009_r + 197, 18, 18));
        }
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int eventType) {
        super.func_146286_b(mouseX, mouseY, eventType);
        if (this.selectedButton != null && eventType == 0) {
            this.selectedButton.func_146118_a(mouseX, mouseY);
            this.selectedButton = null;
        }
    }

    private class BuilderEraseButton extends GuiButton {
        private boolean clicked;

        public BuilderEraseButton(int id, int x, int y, int width, int height) {
            super(id, x, y, width, height, null);
        }

        @Override
        public boolean func_146116_c(Minecraft mc, int x, int y) {
            if (super.func_146116_c(mc, x, y)) {
                selectedButton = this;
                clicked = true;
                BuildCraftCore.instance.sendToServer(new PacketCommand(builder, "eraseFluidTank", new CommandWriter() {
                    @Override
                    public void write(ByteBuf data) {
                        data.writeInt(field_146127_k);
                    }
                }));
                return true;
            } else {
                return false;
            }
        }

        @Override
        public void func_146118_a(int x, int y) {
            super.func_146118_a(x, y);
            clicked = false;
        }

        @Override
        public void func_146112_a(Minecraft mc, int x, int y) {
            if (!field_146125_m) {
                return;
            }
            // hovered
            this.field_146123_n = x >= this.field_146128_h && y >= this.field_146129_i && x < this.field_146128_h + this.field_146120_f && y < this.field_146129_i + this.field_146121_g;

            mc.field_71446_o.func_110577_a(BLUEPRINT_TEXTURE);
            func_73729_b(field_146128_h, field_146129_i, 0, (clicked ? 1 : this.field_146123_n ? 2 : 0) * 18, 18, 18);
            func_146119_b(mc, x, y);
        }
    }
}
