package buildcraft.builders.gui;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;

import buildcraft.core.blueprints.RequirementItemStack;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;

public class SlotBuilderRequirement extends AdvancedSlot {
    public RequirementItemStack stack;

    public SlotBuilderRequirement(GuiAdvancedInterface gui, int x, int y) {
        super(gui, x, y);
    }

    @Override
    public ItemStack getItemStack() {
        return stack != null ? stack.stack : null;
    }

    @Override
    public void drawStack(ItemStack item) {
        int cornerX = (gui.field_146294_l - gui.xSize()) / 2;
        int cornerY = (gui.field_146295_m - gui.ySize()) / 2;

        GlStateManager.func_179131_c(1, 1, 1, 1);

        RenderHelper.func_74520_c();
        gui.drawStack(item, cornerX + x, cornerY + y);

        if (stack != null) {
            // Render real stack size
            String s = String.valueOf(stack.size > 999 ? Math.min(99, stack.size / 1000) + "K" : stack.size);
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            gui.getFontRenderer().func_175063_a(s, cornerX + x + 17 - gui.getFontRenderer().func_78256_a(s), cornerY + y + 9, 16777215);
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
    }
}
