/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders.render;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.item.ItemStack;

import buildcraft.builders.TileConstructionMarker;
import buildcraft.core.EntityLaser;
import buildcraft.core.render.RenderBoxProvider;
import buildcraft.core.render.RenderBuildingItems;
import buildcraft.core.render.RenderLaser;

public class RenderConstructionMarker extends RenderBoxProvider<TileConstructionMarker> {
    private final RenderBuildingItems renderItems = new RenderBuildingItems();

    private ModelBase model = new ModelBase() {};
    private ModelRenderer box;

    public RenderConstructionMarker() {
        box = new ModelRenderer(model, 0, 1);
        box.func_78789_a(-8F, -8F, -8F, 16, 4, 16);
        box.field_78800_c = 8;
        box.field_78797_d = 8;
        box.field_78798_e = 8;
    }

    @Override
    public void func_180535_a(TileConstructionMarker marker, double x, double y, double z, float f, int aThing) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bpt_marker");
        super.func_180535_a(marker, x, y, z, f, aThing);

        if (marker != null) {
            GL11.glPushMatrix();
            GL11.glPushAttrib(GL11.GL_ENABLE_BIT);
            GlStateManager.func_179089_o();
            GlStateManager.func_179145_e();
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b(GL11.GL_SRC_ALPHA, GL11.GL_ONE_MINUS_SRC_ALPHA);

            GL11.glTranslated(x, y, z);
            GL11.glTranslated(-marker.func_174877_v().func_177958_n(), -marker.func_174877_v().func_177956_o(), -marker.func_174877_v().func_177952_p());

            if (marker.laser != null) {
                GL11.glPushMatrix();
                RenderLaser.doRenderLaser(TileEntityRendererDispatcher.field_147556_a.field_147550_f, Minecraft.func_71410_x().field_71446_o, marker.laser,
                        EntityLaser.LASER_STRIPES_YELLOW);
                GL11.glPopMatrix();
            }

            if (marker.itemBlueprint != null) {
                doRenderItem(marker.itemBlueprint, marker.func_174877_v().func_177958_n() + 0.5F, marker.func_174877_v().func_177956_o() + 0.2F, marker.func_174877_v().func_177952_p() + 0.5F);
            }

            GlStateManager.func_179084_k();
            GL11.glPopAttrib();
            GL11.glPopMatrix();

            renderItems.render(marker, x, y, z);
        }
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    public void doRenderItem(ItemStack stack, double x, double y, double z) {
        if (stack == null) {
            return;
        }

        float renderScale = 1.5f;
        GL11.glPushMatrix();
        GL11.glTranslatef((float) x, (float) y, (float) z);
        GL11.glTranslatef(0, 0.25F, 0);
        GL11.glScalef(renderScale, renderScale, renderScale);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
        Minecraft.func_71410_x().func_175599_af().func_180454_a(stack, model);

        GL11.glPopMatrix();
    }
}
