package buildcraft.builders.render;

import net.minecraft.client.Minecraft;
import net.minecraft.util.Vec3;

import buildcraft.builders.TileQuarry;
import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.client.render.RenderResizableCuboid;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.render.RenderBuilder;

public class RenderQuarry extends RenderBuilder<TileQuarry> {
    @Override
    public void func_180535_a(TileQuarry quarry, double x, double y, double z, float partialTicks, int arg) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("bc");
        Minecraft.func_71410_x().field_71424_I.func_76320_a("quarry");
        super.func_180535_a(quarry, x, y, z, partialTicks, arg);

        Minecraft.func_71410_x().field_71424_I.func_76320_a("arm");
        if (quarry.arm != null) {
            if (quarry.arm.xArm != null) {
                renderCuboid(quarry, quarry.arm.xArm, x, y, z, partialTicks);
            }
            if (quarry.arm.yArm != null) {
                renderCuboid(quarry, quarry.arm.yArm, x, y, z, partialTicks);
            }
            if (quarry.arm.zArm != null) {
                renderCuboid(quarry, quarry.arm.zArm, x, y, z, partialTicks);
            }
            if (quarry.arm.headEntity != null) {
                renderCuboid(quarry, quarry.arm.headEntity, x, y, z, partialTicks);
            }
        }

        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private static void renderCuboid(TileQuarry quarry, EntityResizableCuboid cuboid, double x, double y, double z, float partialTicks) {
        Vec3 interp = Utils.getInterpolatedVec(cuboid, partialTicks);
        interp = interp.func_178788_d(Utils.convert(quarry.func_174877_v()));
        interp = interp.func_72441_c(x, y, z);
        RenderResizableCuboid.INSTANCE.func_76986_a(cuboid, interp.field_72450_a, interp.field_72448_b, interp.field_72449_c, 0, partialTicks);
    }
}
