/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders.schematics;

import java.util.List;

import net.minecraft.block.BlockBed;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicBlock;

public class SchematicBed extends SchematicBlock {

    @Override
    public void getRequirementsForPlacement(IBuilderContext context, List<ItemStack> requirements) {
        if (state.getValue(BlockBed.field_176472_a) == BlockBed.EnumPartType.HEAD) {
            requirements.add(new ItemStack(Items.field_151104_aV));
        }
    }

    @Override
    public void storeRequirements(IBuilderContext context, BlockPos pos) {
        // cancel requirements reading
    }

    @Override
    public void rotateLeft(IBuilderContext context) {
        IBlockState oldState = state;
        EnumFacing oldFacing = (EnumFacing) oldState.func_177229_b(BlockBed.field_176387_N);
        state = oldState.func_177226_a(BlockBed.field_176387_N, oldFacing.func_176746_e());
    }

    @Override
    public void placeInWorld(IBuilderContext context, BlockPos pos, List<ItemStack> stacks) {
        context.world().setBlockState(pos, state.withProperty(BlockBed.field_176472_a, BlockBed.EnumPartType.HEAD));
        BlockPos feetPos = pos.func_177967_a(state.getValue(getFacingProp()), -1);
        context.world().setBlockState(feetPos, state.withProperty(BlockBed.field_176472_a, BlockBed.EnumPartType.FOOT));
    }

    @Override
    public boolean doNotBuild() {
        return state.getValue(BlockBed.field_176472_a) == BlockBed.EnumPartType.FOOT;
    }
}
