/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.builders.schematics;

import java.util.List;

import net.minecraft.block.BlockDoor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.core.builders.schematics.SchematicBlockFloored;

public class SchematicDoor extends SchematicBlockFloored {

    final ItemStack stack;

    public SchematicDoor(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public void getRequirementsForPlacement(IBuilderContext context, List<ItemStack> requirements) {
        if (state.getValue(BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            requirements.add(stack.func_77946_l());
        }
    }

    @Override
    public void storeRequirements(IBuilderContext context, BlockPos pos) {
        // cancel requirements reading
    }

    @Override
    public boolean doNotBuild() {
        return state.getValue(BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.UPPER;
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context, BlockPos pos) {
        return state.getBlock() == context.world().getBlockState(pos).getBlock();
    }

    @Override
    public void placeInWorld(IBuilderContext context, BlockPos pos, List<ItemStack> stacks) {
        context.world().setBlockState(pos, state);
        context.world().setBlockState(pos.func_177984_a(), state.withProperty(BlockDoor.field_176523_O, BlockDoor.EnumDoorHalf.UPPER));
    }
}
