package buildcraft.core;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.stats.Achievement;

import net.minecraftforge.common.AchievementPage;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class AchievementManager {
    public final AchievementPage page;

    public AchievementManager(String name) {
        page = new AchievementPage(name);
        AchievementPage.registerAchievementPage(page);
    }

    private Achievement getRegisteredParent(Achievement achievement) {
        if (achievement == null) return null;
        if (AchievementPage.isAchievementInPages(achievement)) return achievement;
        return getRegisteredParent(achievement.field_75992_c);
    }

    /** Will register an {@link Achievement} in this pages, but only if the corresponding block or item is registered
     * with the game. */
    public Achievement registerAchievement(Achievement achievement) {
        boolean registered;
		if (achievement.field_75990_d != null && achievement.field_75990_d.func_77973_b() != null) {
			Item item = achievement.field_75990_d.func_77973_b();
			if (item instanceof ItemBlock) {
				Block block = ((ItemBlock) item).func_179223_d();
				registered = Block.field_149771_c.func_177774_c(block) != null;
			} else {
				registered = Item.field_150901_e.func_177774_c(item) != null;
			}
			if (registered) {
				page.getAchievements().add(achievement);
				achievement.func_75971_g();
				return achievement;
			} else {
				return getRegisteredParent(achievement);
			}
		} else {
			return getRegisteredParent(achievement);
		}
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        Item item = event.crafting.func_77973_b();
        int damage = event.crafting.func_77952_i();

        for (Achievement a : page.getAchievements()) {
            if (item.equals(a.field_75990_d.func_77973_b()) && damage == a.field_75990_d.func_77952_i()) {
                event.player.func_71064_a(a, 1);
            }
        }
    }
}
