package buildcraft.core;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Map.Entry;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatCrafting;
import net.minecraft.stats.StatList;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ResourceLocation;

public enum BCStatCollector {
    INSTANCE;

    private final Map<Block, StatCrafting> blockMined = new IdentityHashMap<>();
    private final Map<Item, StatCrafting> itemCrafted = new IdentityHashMap<>();
    private final Map<Item, StatCrafting> itemUsed = new IdentityHashMap<>();

    public static void registerStats(Block block) {
        if (!block.func_149652_G()) return;

        Item item = Item.func_150898_a(block);

        if (item == null) return;

        String statName = toStatName(item);
        StatCrafting mineBlock = createCrafting("stat.mineBlock", statName, new ItemStack(block));

        StatList.field_75939_e.add(mineBlock);
        INSTANCE.blockMined.put(block, mineBlock);

        registerStats(item);
    }

    public static void registerStats(Item item) {
        String statName = toStatName(item);
        StatCrafting used = createCrafting("stat.useItem", statName, new ItemStack(item));
        StatCrafting craft = createCrafting("stat.craftItem", statName, new ItemStack(item));

        if (!(item instanceof ItemBlock)) {
            StatList.field_75938_d.add(used);
        }

        INSTANCE.itemUsed.put(item, used);
        INSTANCE.itemCrafted.put(item, craft);
    }

    public static StatCrafting createCrafting(String start, String statName, ItemStack stack) {
        Object[] translation = { stack.func_151000_E() };
        StatCrafting stat = new StatCrafting(start + ".", statName, new ChatComponentTranslation(start, translation), stack.func_77973_b());
        stat.func_75971_g();
        return stat;
    }

    private static String toStatName(Item item) {
        ResourceLocation resourcelocation = Item.field_150901_e.func_177774_c(item);
        return resourcelocation != null ? resourcelocation.toString().replace(':', '.') : null;
    }

    public void serverStarting() {
        /* We know that the registry has been frozen at this point so it is safe to fill up the arrays */
        for (Entry<Item, StatCrafting> crafted : itemUsed.entrySet()) {
            StatList.field_75929_E[Item.func_150891_b(crafted.getKey())] = crafted.getValue();
        }
        for (Entry<Item, StatCrafting> crafted : itemCrafted.entrySet()) {
            StatList.field_75928_D[Item.func_150891_b(crafted.getKey())] = crafted.getValue();
        }
    }
}
