package buildcraft.core;

import java.util.List;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;

import buildcraft.api.enums.EnumDecoratedBlock;
import buildcraft.core.lib.block.BlockBuildCraftBase;

public class BlockDecoration extends BlockBuildCraftBase {
    public BlockDecoration() {
        super(Material.field_151573_f, DECORATED_TYPE);
        func_149647_a(null);
    }

    @SuppressWarnings({ "unchecked", "rawtypes" })
    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        // for (EnumDecoratedBlock type : EnumDecoratedBlock.values()) {
        list.add(new ItemStack(this, 1, 0));
        // }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(DECORATED_TYPE).ordinal();
    }

    @Override
    public int getLightValue(IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this) {
            EnumDecoratedBlock type = state.func_177229_b(DECORATED_TYPE);
            return type.lightValue;
        }
        return super.getLightValue(world, pos);
    }
}
