/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core;

import java.util.List;
import java.util.Random;

import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

import buildcraft.api.enums.EnumSpring;
import buildcraft.core.lib.block.BlockBuildCraftBase;
import buildcraft.core.lib.utils.XorShift128Random;

public class BlockSpring extends BlockBuildCraftBase {

    public static final XorShift128Random rand = new XorShift128Random();

    public BlockSpring() {
        super(Material.field_151576_e, SPRING_TYPE);
        func_149722_s();
        func_149752_b(6000000.0F);
        func_149672_a(field_149769_e);

        func_149649_H();
        func_149675_a(true);
        func_149647_a(BCCreativeTab.get("main"));
    }

    @Override
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (EnumSpring type : EnumSpring.VALUES) {
            list.add(new ItemStack(this, 1, type.ordinal()));
        }
    }

    @Override
    public int func_180651_a(IBlockState state) {
        return state.func_177229_b(SPRING_TYPE).ordinal();
    }

    @Override
    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        assertSpring(world, pos, state);
    }

    // @Override
    // public void onNeighborBlockChange(World world, int x, int y, int z, int blockid) {
    // assertSpring(world, x, y, z);
    // }

    @Override
    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        world.func_175684_a(pos, this, state.func_177229_b(SPRING_TYPE).tickRate);
    }

    private void assertSpring(World world, BlockPos pos, IBlockState state) {
        EnumSpring spring = (EnumSpring) state.func_177229_b(SPRING_TYPE);
        world.func_175684_a(pos, this, spring.tickRate);
        if (!spring.canGen || spring.liquidBlock == null) {
            return;
        }
        if (!world.func_175623_d(pos.func_177984_a())) {
            return;
        }
        if (spring.chance != -1 && rand.nextInt(spring.chance) != 0) {
            return;
        }
        world.func_175656_a(pos.func_177984_a(), spring.liquidBlock);
    }

    // Prevents updates on chunk generation
    // @Override
    // public boolean func_149698_L() {
    // return false;
    // }
}
