/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

public class EntityLaser extends Entity {

    public static final ResourceLocation LASER_RED = new ResourceLocation("buildcraftcore:textures/lasers/red.png");
    public static final ResourceLocation LASER_YELLOW = new ResourceLocation("buildcraftcore:textures/lasers/yellow.png");
    public static final ResourceLocation LASER_GREEN = new ResourceLocation("buildcraftcore:textures/lasers/green.png");
    public static final ResourceLocation LASER_BLUE = new ResourceLocation("buildcraftcore:textures/lasers/blue.png");

    public static final ResourceLocation LASER_STRIPES_BLUE = new ResourceLocation("buildcraftcore:textures/lasers/stripes_blue.png");
    public static final ResourceLocation LASER_STRIPES_YELLOW = new ResourceLocation("buildcraftcore:textures/lasers/stripes_yellow.png");

    private static final int NETWORK_HEAD_X = 8;
    private static final int NETWORK_HEAD_Y = 9;
    private static final int NETWORK_HEAD_Z = 10;
    private static final int NETWORK_TAIL_X = 11;
    private static final int NETWORK_TAIL_Y = 12;
    private static final int NETWORK_TAIL_Z = 13;
    private static final int NETWORK_VISIBLE = 14;

    public final LaserData data = new LaserData();

    protected boolean needsUpdate = true;

    private final ResourceLocation laserTexture;

    public static ResourceLocation getTextureFromLaserKind(LaserKind kind) {
        switch (kind) {
            case Blue:
                return LASER_BLUE;
            case Red:
                return LASER_RED;
            case Stripes:
                return LASER_STRIPES_YELLOW;
            default:
                return LASER_STRIPES_BLUE;
        }
    }

    public EntityLaser(World world) {
        this(world, new Vec3(0, 0, 0), new Vec3(0, 0, 0));
    }

    public EntityLaser(World world, Vec3 head, Vec3 tail) {
        this(world, head, tail, LASER_RED);
    }

    public EntityLaser(World world, Vec3 head, Vec3 tail, LaserKind kind) {
        this(world, head, tail, getTextureFromLaserKind(kind));
    }

    public EntityLaser(World world, Vec3 head, Vec3 tail, ResourceLocation laserTexture) {
        super(world);

        data.head = head;
        data.tail = tail;

        func_70080_a(head.field_72450_a, head.field_72448_b, head.field_72449_c, 0, 0);
        func_70105_a(10, 10);

        this.laserTexture = laserTexture;

        updateDataServer();
    }

    @Override
    protected void func_70088_a() {
        field_70156_m = false;
        field_70145_X = true;
        field_70178_ae = true;
        field_70180_af.func_75682_a(NETWORK_HEAD_X, (float) 0);
        field_70180_af.func_75682_a(NETWORK_HEAD_Y, (float) 0);
        field_70180_af.func_75682_a(NETWORK_HEAD_Z, (float) 0);
        field_70180_af.func_75682_a(NETWORK_TAIL_X, (float) 0);
        field_70180_af.func_75682_a(NETWORK_TAIL_Y, (float) 0);
        field_70180_af.func_75682_a(NETWORK_TAIL_Z, (float) 0);

        field_70180_af.func_75682_a(NETWORK_VISIBLE, (byte) 0);
    }

    @Override
    public void func_70071_h_() {
        if (data.head == null || data.tail == null) {
            return;
        }

        if (!field_70170_p.field_72995_K && needsUpdate) {
            updateDataServer();
            needsUpdate = false;
        }

        if (field_70170_p.field_72995_K) {
            updateDataClient();
        }

        // TODO (1.8): Avoid Object Overflow
        // Err... what?
        func_174826_a(new AxisAlignedBB(Math.min(data.head.field_72450_a, data.tail.field_72450_a), Math.min(data.head.field_72448_b, data.tail.field_72448_b) - 1.0D, Math
                .min(data.head.field_72449_c, data.tail.field_72449_c) - 1.0D, Math.max(data.head.field_72450_a, data.tail.field_72450_a) + 1.0D, Math.max(data.head.field_72448_b,
                        data.tail.field_72448_b) + 1.0D, Math.max(data.head.field_72449_c, data.tail.field_72449_c) + 1.0D));

        data.update();
    }

    protected void updateDataClient() {
        data.isVisible = field_70180_af.func_75683_a(NETWORK_VISIBLE) == 1;
    }

    protected void updateDataServer() {
        field_70180_af.func_75692_b(NETWORK_HEAD_X, (float) data.head.field_72450_a);
        field_70180_af.func_75692_b(NETWORK_HEAD_Y, (float) data.head.field_72448_b);
        field_70180_af.func_75692_b(NETWORK_HEAD_Z, (float) data.head.field_72449_c);
        field_70180_af.func_75692_b(NETWORK_TAIL_X, (float) data.tail.field_72450_a);
        field_70180_af.func_75692_b(NETWORK_TAIL_Y, (float) data.tail.field_72448_b);
        field_70180_af.func_75692_b(NETWORK_TAIL_Z, (float) data.tail.field_72449_c);
        field_70180_af.func_75692_b(NETWORK_VISIBLE, (byte) (data.isVisible ? 1 : 0));
    }

    public void setPositions(Vec3 head, Vec3 tail) {
        data.head = head;
        data.tail = tail;

        func_70080_a(head.field_72450_a, head.field_72448_b, head.field_72449_c, 0, 0);

        needsUpdate = true;
    }

    public void show() {
        data.isVisible = true;
        needsUpdate = true;
    }

    public void hide() {
        data.isVisible = false;
        needsUpdate = true;
    }

    public boolean isVisible() {
        return data.isVisible;
    }

    public ResourceLocation getTexture() {
        return laserTexture;
    }

    protected double decodeDouble(float i) {
        return i;
    }

    // The read/write to nbt seem to be useless

    // Yes it is- we never want to persist this entity.

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        double headX = nbt.func_74769_h("headX");
        double headY = nbt.func_74769_h("headZ");
        double headZ = nbt.func_74769_h("headY");
        data.head = new Vec3(headX, headY, headZ);

        double tailX = nbt.func_74769_h("tailX");
        double tailY = nbt.func_74769_h("tailZ");
        double tailZ = nbt.func_74769_h("tailY");
        data.tail = new Vec3(tailX, tailY, tailZ);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74780_a("headX", data.head.field_72450_a);
        nbt.func_74780_a("headY", data.head.field_72448_b);
        nbt.func_74780_a("headZ", data.head.field_72449_c);

        nbt.func_74780_a("tailX", data.tail.field_72450_a);
        nbt.func_74780_a("tailY", data.tail.field_72448_b);
        nbt.func_74780_a("tailZ", data.tail.field_72449_c);
    }

    // Workaround for the laser's posY loosing it's precision e.g 103.5 becomes 104
    public Vec3 renderOffset() {
        return new Vec3(0.5, 0.5, 0.5);
    }

    @Override
    public int func_70070_b(float par1) {
        return 210;
    }
}
