/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core;

import java.util.HashSet;
import java.util.Set;

import net.minecraft.block.*;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

import buildcraft.api.tools.IToolWrench;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.utils.BlockUtils;

public class ItemWrench extends ItemBuildCraft implements IToolWrench {
    private final Set<Class<? extends Block>> shiftRotations = new HashSet<>();
    private final Set<Class<? extends Block>> blacklistedRotations = new HashSet<>();

    public ItemWrench() {
        super();

        func_77664_n();
        func_77625_d(1);
        shiftRotations.add(BlockLever.class);
        shiftRotations.add(BlockButton.class);
        shiftRotations.add(BlockChest.class);
        blacklistedRotations.add(BlockBed.class);
        setHarvestLevel("wrench", 0);
    }

    private boolean isClass(Set<Class<? extends Block>> set, Class<? extends Block> cls) {
        for (Class<? extends Block> shift : set) {
            if (shift.isAssignableFrom(cls)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY,
            float hitZ) {
        Block block = world.func_180495_p(pos).func_177230_c();

        if (block == null || isClass(blacklistedRotations, block.getClass())) {
            return false;
        }

        if (player.func_70093_af() != isClass(shiftRotations, block.getClass())) {
            return false;
        }

        // Double chests should NOT be rotated.
        if (block instanceof BlockChest && BlockUtils.getOtherDoubleChest(world.func_175625_s(pos)) != null) {
            return false;
        }

        if (block.rotateBlock(world, pos, side)) {
            player.func_71038_i();
            return !world.field_72995_K;
        }
        return false;
    }

    @Override
    public boolean canWrench(EntityPlayer player, BlockPos pos) {
        return true;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, BlockPos pos) {
        player.func_71038_i();
    }

    @Override
    public boolean doesSneakBypassUse(World world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    @Override
    public boolean canWrench(EntityPlayer player, Entity entity) {
        return true;
    }

    @Override
    public void wrenchUsed(EntityPlayer player, Entity entity) {
        player.func_71038_i();
    }
}
