/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.blueprints;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;

/** Use the template system to describe fillers */
public class Template extends BlueprintBase {

    public Template() {
        id.extension = "tpl";
    }

    public Template(BlockPos size) {
        super(size);
        id.extension = "tpl";
    }

    @Override
    public void readFromWorld(IBuilderContext context, TileEntity anchorTile, BlockPos pos) {
        Vec3 nPos = Utils.convert(pos).func_178788_d(Utils.convert(context.surroundingBox().min()));

        if (!BuildCraftAPI.isSoftBlock(anchorTile.func_145831_w(), pos)) {
            set(Utils.convertFloor(nPos), new SchematicMask(true));
        }
    }

    @Override
    public void saveContents(NBTTagCompound nbt) {
        // Note: this way of storing data is suboptimal, we really need a bit
        // per mask entry, not a byte. However, this is fine, as compression
        // will fix it.

        byte[] data = new byte[size.func_177958_n() * size.func_177956_o() * size.func_177952_p()];
        int ind = 0;

        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    data[ind] = (byte) ((get(new BlockPos(x, y, z)) == null) ? 0 : 1);
                    ind++;
                }
            }
        }

        nbt.func_74773_a("mask", data);
    }

    @Override
    public void loadContents(NBTTagCompound nbt) throws BptError {
        byte[] data = nbt.func_74770_j("mask");
        int ind = 0;

        BCLog.logger.info("size = " + size);

        for (int x = 0; x < size.func_177958_n(); ++x) {
            for (int y = 0; y < size.func_177956_o(); ++y) {
                for (int z = 0; z < size.func_177952_p(); ++z) {
                    if (data[ind] == 1) {
                        set(new BlockPos(x, y, z), new SchematicMask(true));
                    }
                    ind++;
                }
            }
        }
    }

    @Override
    public ItemStack getStack() {
        Item item = Item.field_150901_e.func_82594_a(new ResourceLocation("BuildCraft|Builders:templateItem"));
        if (item == null) {
            throw new Error("Could not find the template item! Did you attempt to use this without buildcraft builders installed?");
        }
        ItemStack stack = new ItemStack(item, 1, 1);
        NBTTagCompound nbt = NBTUtils.getItemData(stack);
        id.write(nbt);
        nbt.func_74778_a("author", author);
        nbt.func_74778_a("name", id.name);

        return stack;
    }

}
