package buildcraft.core.builders;

import java.util.List;

import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

import buildcraft.api.blueprints.IBuilderContext;

public class BuilderItemMetaPair {
    public Item item;
    public int meta;
    public int position = 0;

    public BuilderItemMetaPair(ItemStack stack) {
        if (stack != null && stack.func_77973_b() != null) {
            this.item = stack.func_77973_b();
            this.meta = stack.func_77952_i();
        } else {
            this.item = Item.func_150898_a(Blocks.field_150350_a);
            this.meta = 0;
        }
    }

    public BuilderItemMetaPair(IBuilderContext context, BuildingSlotBlock block) {
        this(findStack(context, block));
    }

    private static ItemStack findStack(IBuilderContext context, BuildingSlotBlock block) {
        List<ItemStack> s = block.getRequirements(context);
        return s.size() > 0 ? s.get(0) : null;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BuilderItemMetaPair) {
            BuilderItemMetaPair imp = (BuilderItemMetaPair) o;
            return imp.item == item && imp.meta == meta;
        }

        return false;
    }

    @Override
    public int hashCode() {
        return Item.func_150891_b(item) * 17 + meta;
    }
}
