/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.builders.patterns;

import net.minecraft.world.World;

import buildcraft.api.enums.EnumFillerPattern;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Template;

public final class PatternFill extends FillerPattern {

    public static final PatternFill INSTANCE = new PatternFill();

    private PatternFill() {
        super("fill", EnumFillerPattern.FILL);
    }

    @Override
    public Template getTemplate(Box box, World world, IStatementParameter[] parameters) {
        Template bpt = new Template(box.size());

        fill(0, 0, 0, box.size().func_177958_n() - 1, box.size().func_177956_o() - 1, box.size().func_177952_p() - 1, bpt);

        return bpt;
    }
}
