/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.builders.patterns;

import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.enums.EnumFillerPattern;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.Template;

public class PatternFlatten extends FillerPattern {

    public PatternFlatten() {
        super("flatten", EnumFillerPattern.FLATTEN);
    }

    @Override
    public Template getTemplate(Box box, World world, IStatementParameter[] parameters) {
        int xMin = box.min().func_177958_n();
        int yMin = box.min().func_177956_o() > 0 ? (int) box.min().func_177956_o() - 1 : 0;
        int zMin = box.min().func_177952_p();

        int xMax = box.max().func_177958_n();
        int yMax = box.max().func_177956_o();
        int zMax = box.max().func_177952_p();

        Template bpt = new Template(new BlockPos(box.size().func_177958_n(), yMax - yMin + 1, box.size().func_177952_p()));

        if (box.min().func_177956_o() > 0) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    bpt.set(new BlockPos(x - xMin, 0, z - zMin), new SchematicMask(true));
                }
            }
        }

        return bpt;
    }

    @Override
    public BptBuilderTemplate getTemplateBuilder(Box box, World world, IStatementParameter[] parameters) {
        int yMin = box.min().func_177956_o() > 0 ? (int) box.min().func_177956_o() - 1 : 0;

        return new BptBuilderTemplate(getTemplate(box, world, parameters), world, new BlockPos(box.min().func_177958_n(), yMin, box.min().func_177952_p()));
    }
}
