/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.builders.patterns;

import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.enums.EnumFillerPattern;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Template;

public class PatternFrame extends FillerPattern {

    public PatternFrame() {
        super("frame", EnumFillerPattern.FRAME);
    }

    @Override
    public Template getTemplate(Box box, World world, IStatementParameter[] parameters) {
        Template template = new Template(box.size());

        int xMax = box.size().func_177958_n() - 1;
        int zMax = box.size().func_177952_p() - 1;

        for (int it = 0; it < 2; it++) {
            int y = it * (box.size().func_177956_o() - 1);
            for (int i = 0; i < template.size.func_177958_n(); ++i) {
                template.set(new BlockPos(i, y, 0), new SchematicMask(true));
                template.set(new BlockPos(i, y, zMax), new SchematicMask(true));
            }

            for (int k = 0; k < template.size.func_177952_p(); ++k) {
                template.set(new BlockPos(0, y, k), new SchematicMask(true));
                template.set(new BlockPos(xMax, y, k), new SchematicMask(true));
            }
        }

        for (int h = 1; h < box.size().func_177956_o(); ++h) {
            template.set(new BlockPos(0, h, 0), new SchematicMask(true));
            template.set(new BlockPos(0, h, zMax), new SchematicMask(true));
            template.set(new BlockPos(xMax, h, 0), new SchematicMask(true));
            template.set(new BlockPos(xMax, h, zMax), new SchematicMask(true));
        }

        return template;
    }
}
