package buildcraft.core.crops;

import java.util.List;

import net.minecraft.block.*;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

import net.minecraftforge.common.IPlantable;

import buildcraft.api.crops.ICropHandler;
import buildcraft.core.lib.utils.BlockUtils;

public class CropHandlerPlantable implements ICropHandler {

    @Override
    public boolean isSeed(ItemStack stack) {
        if (stack.func_77973_b() instanceof IPlantable) {
            return true;
        }

        if (stack.func_77973_b() instanceof ItemBlock) {
            Block block = ((ItemBlock) stack.func_77973_b()).field_150939_a;
            if (block instanceof IPlantable && block != Blocks.field_150436_aH) {
                return true;
            }
        }

        return false;
    }

    @Override
    public boolean canSustainPlant(World world, ItemStack seed, BlockPos pos) {
        if (seed.func_77973_b() instanceof IPlantable) {
            Block block = world.func_180495_p(pos).func_177230_c();
            return block.canSustainPlant(world, pos, EnumFacing.UP, (IPlantable) seed.func_77973_b()) && world.func_175623_d(pos.func_177984_a());
        } else {
            Block block = world.func_180495_p(pos).func_177230_c();
            IPlantable plantable = (IPlantable) ((ItemBlock) seed.func_77973_b()).field_150939_a;
            return block.canSustainPlant(world, pos, EnumFacing.UP, plantable) && block != ((ItemBlock) seed.func_77973_b()).field_150939_a && world.func_175623_d(pos
                    .func_177984_a());
        }
    }

    @Override
    public boolean plantCrop(World world, EntityPlayer player, ItemStack seed, BlockPos pos) {
        return BlockUtils.useItemOnBlock(world, player, seed, pos, EnumFacing.UP);
    }

    @Override
    public boolean isMature(IBlockAccess blockAccess, IBlockState state, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof BlockFlower || block instanceof BlockTallGrass || block instanceof BlockMelon || block instanceof BlockMushroom
            || block instanceof BlockDoublePlant || block == Blocks.field_150423_aK) {
            return true;
        } else if (block instanceof BlockCrops) {
            return state.func_177229_b(BlockCrops.field_176488_a) == 7;
        } else if (block instanceof BlockNetherWart) {
            return state.func_177229_b(BlockNetherWart.field_176486_a) == 3;
        } else if (block instanceof IPlantable) {
            if (blockAccess.func_180495_p(pos.func_177977_b()).func_177230_c() == block) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean harvestCrop(World world, BlockPos pos, List<ItemStack> drops) {
        if (!world.field_72995_K) {
            IBlockState state = world.func_180495_p(pos);
            if (BlockUtils.breakBlock((WorldServer) world, pos, drops)) {
                world.func_180498_a(null, 2001, pos, Block.func_176210_f(state));
                return true;
            }
        }
        return false;
    }
}
