/** Copyright (c) 2011-2014, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 *
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib;

import java.util.Arrays;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;

import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityResizableCuboid extends Entity {

    public float shadowSize = 0;
    public float rotationX = 0;
    public float rotationY = 0;
    public float rotationZ = 0;
    public double xSize, ySize, zSize;
    private int brightness = -1;
    public ResourceLocation resource;
    public IBlockState blockState;

    /** The texture that is used for all sides of the cube */
    @SideOnly(Side.CLIENT)
    public TextureAtlasSprite texture;

    /** This should be a size 6 array of textures for each side. If a texture is null, it is not rendered. */
    @SideOnly(Side.CLIENT)
    public TextureAtlasSprite[] textures;

    /** Where the texture is considered to start. Essentially is used to point the position of the starting point of the
     * texture */
    public double textureStartX = 0, textureStartY = 0, textureStartZ = 0;

    /** The size of the texture before going back to the start. */
    public double textureSizeX = 16, textureSizeY = 16, textureSizeZ = 16;

    /** What the texture should be offset by. Essentially where should the texture start from. (However it repeats back
     * around to textureStart* on the texture)
     * <p>
     * For example, a 1 dimensional texture that looks like this:
     * <p>
     * 0123
     * <p>
     * With textureOffsetX set to 2 (and a textureSizeX of 4) would repeat like this:
     * <p>
     * 230123 */
    public double textureOffsetX = 0, textureOffsetY = 0, textureOffsetZ = 0;

    /** An array containing the flips of the textures for each of the sides. 0 is none, 1 flips the U's and 2 flips the
     * V's (3 flips both) */
    @SideOnly(Side.CLIENT)
    public int[] textureFlips;

    public EntityResizableCuboid(World world) {
        super(world);
        field_70158_ak = true;
        field_70156_m = false;
        field_70145_X = true;
        field_70178_ae = true;
        field_70158_ak = true;
    }

    public EntityResizableCuboid(World world, double xPos, double yPos, double zPos) {
        this(world);
        func_70080_a(xPos, yPos, zPos, 0, 0);
    }

    public EntityResizableCuboid(World world, double i, double j, double k, double iSize, double jSize, double kSize) {
        this(world);
        this.xSize = iSize;
        this.ySize = jSize;
        this.zSize = kSize;
        func_70080_a(i, j, k, 0, 0);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
    }

    /** A simple method to initialise all client side only variables if they have not already been initialised. */
    @SideOnly(Side.CLIENT)
    public void makeClient() {
        if (textures == null) {
            textures = new TextureAtlasSprite[6];
            Arrays.fill(textures, texture);
        }
        if (textureFlips == null) {
            textureFlips = new int[6];
        }
    }

    @Override
    public void func_70107_b(double d, double d1, double d2) {
        super.func_70107_b(d, d1, d2);
        this.func_174826_a(AxisAlignedBB.func_178781_a(field_70165_t, field_70163_u, field_70161_v, field_70165_t + xSize, field_70163_u + ySize, field_70161_v + zSize));
    }

    @Override
    public void func_70091_d(double d, double d1, double d2) {
        func_70107_b(field_70165_t + d, field_70163_u + d1, field_70161_v + d2);
    }

    public void setSize(Vec3 size) {
        xSize = size.field_72450_a;
        ySize = size.field_72448_b;
        zSize = size.field_72449_c;
    }

    @SideOnly(Side.CLIENT)
    public void setTextureOffset(Vec3 offset) {
        textureOffsetX = offset.field_72450_a;
        textureOffsetY = offset.field_72448_b;
        textureOffsetZ = offset.field_72449_c;
    }

    @SideOnly(Side.CLIENT)
    public void setTextureStart(Vec3 start) {
        textureStartX = start.field_72450_a;
        textureStartY = start.field_72448_b;
        textureStartZ = start.field_72449_c;
    }

    @SideOnly(Side.CLIENT)
    public void setTextureSize(Vec3 size) {
        textureSizeX = size.field_72450_a;
        textureSizeY = size.field_72448_b;
        textureSizeZ = size.field_72449_c;
    }

    public void setBrightness(int brightness) {
        this.brightness = brightness;
    }

    @Override
    protected void func_70088_a() {
        // TODO Auto-generated method stub
    }

    @Override
    protected void func_70037_a(NBTTagCompound data) {
        xSize = data.func_74769_h("iSize");
        ySize = data.func_74769_h("jSize");
        zSize = data.func_74769_h("kSize");
    }

    @Override
    protected void func_70014_b(NBTTagCompound data) {
        data.func_74780_a("iSize", xSize);
        data.func_74780_a("jSize", ySize);
        data.func_74780_a("kSize", zSize);
    }

    @Override
    public int func_70070_b(float par1) {
        return brightness > 0 ? brightness : super.func_70070_b(par1);
    }

    public void setPosition(Vec3 vec) {
        func_70107_b(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }
}
