package buildcraft.core.lib;

import net.minecraft.nbt.NBTTagCompound;

import cofh.api.energy.IEnergyStorage;

public class RFBattery implements IEnergyStorage {
    private int energy, maxEnergy, maxReceive, maxExtract;

    public RFBattery(int maxEnergy, int maxReceive, int maxExtract) {
        this.maxEnergy = maxEnergy;
        this.maxReceive = maxReceive;
        this.maxExtract = maxExtract;
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("energy") && tag.func_74764_b("maxEnergy") && tag.func_74764_b("maxReceive") && tag.func_74764_b("maxExtract")) {
            this.energy = tag.func_74762_e("energy");
            this.maxEnergy = tag.func_74762_e("maxEnergy");
            this.maxReceive = tag.func_74762_e("maxReceive");
            this.maxExtract = tag.func_74762_e("maxExtract");
        }
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("energy", this.energy);
        tag.func_74768_a("maxEnergy", this.maxEnergy);
        tag.func_74768_a("maxReceive", this.maxReceive);
        tag.func_74768_a("maxExtract", this.maxExtract);
    }

    public int addEnergy(int minReceive, int maxReceive, boolean simulate) {
        int amountReceived = Math.min(maxReceive, maxEnergy - energy);

        if (amountReceived < minReceive) {
            return 0;
        }

        if (!simulate) {
            energy += amountReceived;
        }

        return amountReceived;
    }

    public int useEnergy(int minExtract, int maxExtract, boolean simulate) {
        int amountExtracted = Math.min(maxExtract, energy);

        if (amountExtracted < minExtract) {
            return 0;
        }

        if (!simulate) {
            energy -= amountExtracted;
        }

        return amountExtracted;
    }

    @Override
    public int receiveEnergy(int maxReceive, boolean simulate) {
        return addEnergy(0, Math.min(maxReceive, this.maxReceive), simulate);
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        return useEnergy(0, Math.min(maxExtract, this.maxExtract), simulate);
    }

    @Override
    public int getEnergyStored() {
        return energy;
    }

    @Override
    public int getMaxEnergyStored() {
        return maxEnergy;
    }

    public int getMaxEnergyReceive() {
        return maxReceive;
    }

    public int getMaxEnergyExtract() {
        return maxExtract;
    }

    public void setEnergy(int iEnergy) {
        energy = iEnergy;

        if (energy < 0) {
            energy = 0;
        } else if (energy > maxEnergy) {
            energy = maxEnergy;
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("RFBattery [energy=");
        builder.append(energy);
        builder.append(", maxEnergy=");
        builder.append(maxEnergy);
        builder.append(", maxReceive=");
        builder.append(maxReceive);
        builder.append(", maxExtract=");
        builder.append(maxExtract);
        builder.append("]");
        return builder.toString();
    }
}
