package buildcraft.core.lib.client.model;

import java.util.Collections;
import java.util.List;

import javax.vecmath.Matrix4f;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;

import org.apache.commons.lang3.tuple.Pair;

import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms.TransformType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.TRSRTransformation;

import net.minecraft.client.renderer.block.model.ItemCameraTransforms.TransformType;
public class PerspAwareModelBase implements IPerspectiveAwareModel {
    private final VertexFormat format;
    // TODO: BakedQuad -> UnpackedBakedQuad
    // (mc -> forge)
    private final ImmutableList<BakedQuad> quads;
    private final TextureAtlasSprite particle;
    @SuppressWarnings("deprecation")
    private final ImmutableMap<TransformType, TRSRTransformation> transforms;

    public PerspAwareModelBase(VertexFormat format, ImmutableList<BakedQuad> quads, TextureAtlasSprite particle,
            @SuppressWarnings("deprecation") ImmutableMap<TransformType, TRSRTransformation> transforms) {
        this.format = format;
        this.quads = quads == null ? ImmutableList.<BakedQuad> of() : quads;
        this.particle = particle;
        this.transforms = transforms;
    }

    @Override
    public VertexFormat getFormat() {
        return format;
    }

    @Override
    public List<BakedQuad> func_177551_a(EnumFacing p_177551_1_) {
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> func_177550_a() {
        return quads;
    }

    @Override
    public boolean func_177555_b() {
        return true;
    }

    @Override
    public boolean func_177556_c() {
        return false;
    }

    @Override
    public boolean func_177553_d() {
        return false;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return particle;
    }

    @Override
    @SuppressWarnings("deprecation")
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    @Override
    @SuppressWarnings("deprecation")
    public Pair<? extends IFlexibleBakedModel, Matrix4f> handlePerspective(TransformType cameraTransformType) {
        return IPerspectiveAwareModel.MapWrapper.handlePerspective(this, transforms, cameraTransformType);
    }
}
