/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.client.render;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(Side.CLIENT)
public class EntityDropParticleFX extends EntityFX {

    /** The height of the current bob */
    private int bobTimer;

    public EntityDropParticleFX(World world, double x, double y, double z, float particleRed, float particleGreen, float particleBlue) {
        super(world, x, y, z, 0.0D, 0.0D, 0.0D);
        this.field_70159_w = this.field_70181_x = this.field_70179_y = 0.0D;

        // if (par8Material == Material.water)
        // {
        // this.particleRed = 0.0F;
        // this.particleGreen = 0.0F;
        // this.particleBlue = 1.0F;
        // }
        // else
        // {
        // this.particleRed = 1.0F;
        // this.particleGreen = 0.0F;
        // this.particleBlue = 0.0F;
        // }
        this.field_70552_h = particleRed;
        this.field_70553_i = particleGreen;
        this.field_70551_j = particleBlue;

        this.func_70536_a(113);
        this.func_70105_a(0.01F, 0.01F);
        this.field_70545_g = 0.06F;
        this.bobTimer = 40;
        this.field_70547_e = (int) (64.0D / (Math.random() * 0.8D + 0.2D));
        this.field_70159_w = this.field_70181_x = this.field_70179_y = 0.0D;
    }

    /** Called to update the entity's position/logic. */
    @Override
    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;

        this.field_70181_x -= this.field_70545_g;

        if (this.bobTimer-- > 0) {
            this.field_70159_w *= 0.02D;
            this.field_70181_x *= 0.02D;
            this.field_70179_y *= 0.02D;
            this.func_70536_a(113);
        } else {
            this.func_70536_a(112);
        }

        this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= 0.9800000190734863D;
        this.field_70181_x *= 0.9800000190734863D;
        this.field_70179_y *= 0.9800000190734863D;

        if (this.field_70547_e-- <= 0) {
            this.func_70106_y();
        }

        if (this.field_70122_E) {
            this.func_70536_a(114);

            this.field_70159_w *= 0.699999988079071D;
            this.field_70179_y *= 0.699999988079071D;
        }

        int x = MathHelper.func_76128_c(this.field_70165_t);
        int y = MathHelper.func_76128_c(this.field_70163_u);
        int z = MathHelper.func_76128_c(this.field_70161_v);
        BlockPos pos = new BlockPos(x, y, z);
        Block block = field_70170_p.func_180495_p(pos).func_177230_c();

        Material material = block.func_149688_o();

        if ((material.func_76224_d() || material.func_76220_a()) && block instanceof IFluidBlock) {
            double d0 = MathHelper.func_76128_c(this.field_70163_u) + 1 - ((IFluidBlock) block).getFilledPercentage(field_70170_p, pos);

            if (this.field_70163_u < d0) {
                this.func_70106_y();
            }
        }
    }
}
