/** Copyright (c) 2011-2015, SpaceToad and the BuildCraft Team http://www.mod-buildcraft.com
 * <p/>
 * BuildCraft is distributed under the terms of the Minecraft Mod Public License 1.0, or MMPL. Please check the contents
 * of the license located in http://www.mod-buildcraft.com/MMPL-1.0.txt */
package buildcraft.core.lib.client.render;

import java.util.Map;

import javax.vecmath.Vector3f;

import com.google.common.collect.Maps;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;

import buildcraft.core.lib.utils.Utils;

public enum RenderUtils {
    INSTANCE;

    private final Map<EnumFacing, Vec3> rotations = Maps.newEnumMap(EnumFacing.class);

    private RenderUtils() {
        rotations.put(EnumFacing.UP, Utils.VEC_ZERO);
        rotations.put(EnumFacing.DOWN, new Vec3(180, 0, 0));
        EnumFacing face = EnumFacing.SOUTH;
        for (int a = 0; a < 360; a += 90) {
            rotations.put(face, new Vec3(90, 0, a));
            face = face.func_176746_e();
        }
    }

    public static void setGLColorFromInt(int color) {
        setGLColorFromIntPlusAlpha(0xFF_00_00_00 | color);
    }

    public static void setGLColorFromIntPlusAlpha(int color) {
        float alpha = (color >> 24 & 255) / 255.0F;
        float red = (color >> 16 & 255) / 255.0F;
        float green = (color >> 8 & 255) / 255.0F;
        float blue = (color & 255) / 255.0F;

        GlStateManager.func_179131_c(red, green, blue, alpha);
    }

    public static void setWorldRendererRGB(WorldRenderer wr, Vec3 color) {
        wr.func_181666_a((float) color.field_72450_a, (float) color.field_72448_b, (float) color.field_72449_c, 1f);
    }

    public static void addWorldRendererVertex(WorldRenderer wr, Vec3 vertex) {
        wr.func_181662_b(vertex.field_72450_a, vertex.field_72448_b, vertex.field_72449_c);
    }

    public static void putWorldRendererColorMultiplier(WorldRenderer wr, Vec3 color, int index) {
        wr.func_178978_a((float) color.field_72450_a, (float) color.field_72448_b, (float) color.field_72449_c, index);
    }

    public static void translate(Vec3 vector) {
        GL11.glTranslated(vector.field_72450_a, vector.field_72448_b, vector.field_72449_c);
    }

    public static void vertex3d(Vec3 vec) {
        GL11.glVertex3d(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public static void vertex3f(Vec3 vec) {
        vertex3f(Utils.convertFloat(vec));
    }

    public static void vertex3f(Vector3f vec) {
        GL11.glVertex3f(vec.x, vec.y, vec.z);
    }

    /** Rotates the current matrix to face the specified direction, assuming you want to draw your models upwards */
    public static void rotate(EnumFacing face) {
        rotate(INSTANCE.rotations.get(face));
    }

    public static void rotate(Vec3 rotation) {
        GL11.glRotated(rotation.field_72450_a, 1, 0, 0);
        GL11.glRotated(rotation.field_72448_b, 0, 1, 0);
        GL11.glRotated(rotation.field_72449_c, 0, 0, 1);
    }
}
