package buildcraft.core.lib.client.sprite;

import org.lwjgl.opengl.GL11;

import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class DynamicTextureBC {
    public final int width, height;
    public int[] colorMap;

    @SideOnly(Side.CLIENT)
    protected DynamicTexture dynamicTexture;

    public DynamicTextureBC(int iWidth, int iHeight) {
        width = iWidth;
        height = iHeight;
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            createDynamicTexture();
        } else {
            colorMap = new int[iWidth * iHeight];
        }
    }

    @SideOnly(Side.CLIENT)
    private void createDynamicTexture() {
        dynamicTexture = new DynamicTexture(width, height);
        colorMap = dynamicTexture.func_110565_c();
    }

    public void setColord(int index, double r, double g, double b, double a) {
        int i = (int) (a * 255.0F);
        int j = (int) (r * 255.0F);
        int k = (int) (g * 255.0F);
        int l = (int) (b * 255.0F);
        colorMap[index] = i << 24 | j << 16 | k << 8 | l;
    }

    public void setColord(int x, int y, double r, double g, double b, double a) {
        setColord(x + y * width, r, g, b, a);
    }

    public void setColori(int index, int r, int g, int b, int a) {
        colorMap[index] = (a & 255) << 24 | (r & 255) << 16 | (g & 255) << 8 | (b & 255);
    }

    public void setColori(int x, int y, int r, int g, int b, int a) {
        setColori(x + y * width, r, g, b, a);
    }

    public void setColor(int x, int y, int color) {
        colorMap[x + y * width] = color;
    }

    public void setColor(int x, int y, int color, float alpha) {
        int a = (int) (alpha * 255.0F);

        colorMap[x + y * width] = a << 24 | color;
    }

    @SideOnly(Side.CLIENT)
    public void updateTexture() {
        dynamicTexture.func_110564_a();
    }

    @SideOnly(Side.CLIENT)
    public void draw(int screenX, int screenY, float zLevel) {
        draw(screenX, screenY, zLevel, 0, 0, width, height);
    }

    @SideOnly(Side.CLIENT)
    public void draw(int screenX, int screenY, float zLevel, int clipX, int clipY, int clipWidth, int clipHeight) {
        updateTexture();

        float f = 1F / width;
        float f1 = 1F / height;
        Tessellator tessellator = Tessellator.func_178181_a();
        WorldRenderer wr = tessellator.func_178180_c();
        wr.func_181668_a(GL11.GL_QUADS, wr.func_178973_g());
        vertexUV(wr, screenX + 0, screenY + clipHeight, zLevel, (clipX + 0) * f, (clipY + clipHeight) * f1);
        vertexUV(wr, screenX + clipWidth, screenY + clipHeight, zLevel, (clipX + clipWidth) * f, (clipY + clipHeight) * f1);
        vertexUV(wr, screenX + clipWidth, screenY + 0, zLevel, (clipX + clipWidth) * f, (clipY + 0) * f1);
        vertexUV(wr, screenX + 0, screenY + 0, zLevel, (clipX + 0) * f, (clipY + 0) * f1);
        tessellator.func_78381_a();
    }

    private void vertexUV(WorldRenderer wr, double x, double y, double z, double u, double v) {
        wr.func_181662_b(x, y, z);
        wr.func_181673_a(u, v);
        wr.func_181675_d();
    }
}
